/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.toast;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.registries.PastelSounds;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UnlockedRecipeToast
implements Toast {
    private final ResourceLocation TEXTURE = PastelCommon.locate("textures/gui/toasts.png");
    private final Component title;
    private final Component text;
    private final List<ItemStack> itemStacks;
    private final SoundEvent soundEvent = PastelSounds.NEW_RECIPE;
    private boolean soundPlayed;

    public UnlockedRecipeToast(Component title, Component text, List<ItemStack> itemStacks) {
        this.title = title;
        this.text = text;
        this.itemStacks = itemStacks;
        this.soundPlayed = false;
    }

    public static void showRecipeToast(@NotNull Minecraft client, final ItemStack itemStack, Component title) {
        Component text = UnlockedRecipeToast.getTextForItemStack(itemStack);
        client.getToasts().addToast((Toast)new UnlockedRecipeToast(title, text, (List<ItemStack>)new ArrayList<ItemStack>(){
            {
                this.add(itemStack);
            }
        }));
    }

    public static void showRecipeGroupToast(@NotNull Minecraft client, String groupName, List<ItemStack> itemStacks, Component title) {
        MutableComponent text = Component.translatable((String)("recipeGroup.pastel." + groupName));
        client.getToasts().addToast((Toast)new UnlockedRecipeToast(title, (Component)text, itemStacks));
    }

    public static void showLotsOfRecipesToast(@NotNull Minecraft client, List<ItemStack> itemStacks) {
        client.getToasts().addToast((Toast)new UnlockedRecipeToast((Component)Component.translatable((String)"pastel.toast.lots_of_recipes_unlocked.title"), (Component)Component.translatable((String)"pastel.toast.lots_of_recipes_unlocked.description", (Object[])new Object[]{itemStacks.size()}), itemStacks));
    }

    public static Component getTextForItemStack(@NotNull ItemStack itemStack) {
        List effects;
        if (itemStack.is(Items.ENCHANTED_BOOK)) {
            Set enchantments = itemStack.getEnchantments().entrySet();
            if (!enchantments.isEmpty()) {
                Object2IntMap.Entry enchantEntry = (Object2IntMap.Entry)enchantments.iterator().next();
                return Component.translatable((String)((Holder)enchantEntry.getKey()).getRegisteredName());
            }
        } else if (itemStack.is(Items.POTION) && !(effects = ((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects()).isEmpty()) {
            return Component.translatable((String)((MobEffectInstance)effects.getFirst()).getDescriptionId()).append(" ").append((Component)Component.translatable((String)"item.minecraft.potion"));
        }
        return itemStack.getHoverName();
    }

    public Toast.Visibility render(GuiGraphics drawContext, @NotNull ToastComponent manager, long startTime) {
        drawContext.blit(this.TEXTURE, 0, 0, 0, 32, this.width(), this.height());
        Minecraft client = manager.getMinecraft();
        Font textRenderer = client.font;
        drawContext.drawString(textRenderer, this.title, 30, 7, 0x323232, false);
        drawContext.drawString(textRenderer, this.text, 30, 18, 0, false);
        long toastTimeMilliseconds = PastelCommon.CONFIG.ToastTimeMilliseconds;
        if (!this.soundPlayed && startTime > 0L) {
            this.soundPlayed = true;
            if (this.soundEvent != null) {
                manager.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.soundEvent, (float)1.0f, (float)1.0f));
            }
        }
        int itemStackIndex = (int)(startTime / Math.max(1L, toastTimeMilliseconds / (long)this.itemStacks.size()) % (long)this.itemStacks.size());
        drawContext.renderItem(this.itemStacks.get(itemStackIndex), 8, 8);
        return startTime >= toastTimeMilliseconds ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

