/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class UpgradePlaceCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("upgrade_place");

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, int upgradeCount, Map<Upgradeable.UpgradeType, Integer> upgradeModifiers) {
        this.trigger(player, conditions -> conditions.matches(world, pos, upgradeCount, upgradeModifiers));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<BlockPredicate> blockPredicate, Optional<MinMaxBounds.Ints> countRange, Optional<MinMaxBounds.Ints> speedRange, Optional<MinMaxBounds.Ints> experienceRange, Optional<MinMaxBounds.Ints> efficiencyRange, Optional<MinMaxBounds.Ints> yieldRange) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)BlockPredicate.CODEC.optionalFieldOf("block").forGetter(Conditions::blockPredicate), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("count").forGetter(Conditions::countRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("speed_mod").forGetter(Conditions::speedRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("experience_mod").forGetter(Conditions::experienceRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("efficiency_mod").forGetter(Conditions::efficiencyRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("yield_mod").forGetter(Conditions::yieldRange)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ServerLevel world, BlockPos pos, int upgradeCount, Map<Upgradeable.UpgradeType, Integer> upgradeModifiers) {
            return !(!this.blockPredicate.isEmpty() && !this.blockPredicate.get().matches(world, pos) || !this.countRange.isEmpty() && !this.countRange.get().matches(upgradeCount) || !this.speedRange.isEmpty() && !this.speedRange.get().matches(upgradeModifiers.get((Object)Upgradeable.UpgradeType.SPEED).intValue()) || !this.experienceRange.isEmpty() && !this.experienceRange.get().matches(upgradeModifiers.get((Object)Upgradeable.UpgradeType.EXPERIENCE).intValue()) || !this.efficiencyRange.isEmpty() && !this.efficiencyRange.get().matches(upgradeModifiers.get((Object)Upgradeable.UpgradeType.EFFICIENCY).intValue()) || !this.yieldRange.isEmpty() && !this.yieldRange.get().matches(upgradeModifiers.get((Object)Upgradeable.UpgradeType.YIELD).intValue()));
        }
    }
}

