/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.items.trinkets.TakeOffBeltItem;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TakeOffBeltJumpCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("take_off_belt_jump");

    public static Conditions create(ItemPredicate itemPredicate, MinMaxBounds.Ints chargesRange) {
        return new Conditions(Optional.empty(), itemPredicate, chargesRange);
    }

    public void trigger(ServerPlayer player) {
        this.trigger(player, conditions -> PastelTrinketItem.getFirstEquipped((LivingEntity)player, (Item)PastelItems.TAKE_OFF_BELT.get()).map(belt -> TakeOffBeltItem.getCurrentCharge((Player)player) > 0).orElse(false));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, ItemPredicate itemPredicate, MinMaxBounds.Ints chargesRange) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("item", (Object)ItemPredicate.Builder.item().build()).forGetter(Conditions::itemPredicate), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("charges", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::chargesRange)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack beltStack, int charge) {
            return this.itemPredicate.test(beltStack) && this.chargesRange.matches(charge);
        }
    }
}

