/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class PreservationCheckCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("preservation_check");

    public void trigger(ServerPlayer player, String checkName, boolean checkPassed) {
        this.trigger(player, conditions -> conditions.matches(checkName, checkPassed));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<String> checkName, Optional<Boolean> checkPassed) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)Codec.STRING.optionalFieldOf("check_name").forGetter(Conditions::checkName), (App)Codec.BOOL.optionalFieldOf("check_passed").forGetter(Conditions::checkPassed)).apply((Applicative)instance, Conditions::new));

        public boolean matches(String name, boolean checkPassed) {
            return !(!this.checkPassed.isEmpty() && this.checkPassed.get() != checkPassed || !this.checkName.isEmpty() && !this.checkName.get().equals(name));
        }
    }
}

