/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class PedestalCraftingCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("crafted_with_pedestal");

    public void trigger(ServerPlayer player, ItemStack craftedStack, int experience, int durationTicks) {
        this.trigger(player, conditions -> conditions.matches(craftedStack, experience, durationTicks));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location, Optional<ItemPredicate> craftedItemPredicate, MinMaxBounds.Ints experienceRange, MinMaxBounds.Ints craftingDurationTicksRange) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(Conditions::location), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Conditions::craftedItemPredicate), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("gained_experience", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::experienceRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("crafting_duration_ticks", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::craftingDurationTicksRange)).apply((Applicative)instance, Conditions::new));

        public void validate(CriterionValidator validator) {
            super.validate(validator);
        }

        public boolean matches(ItemStack craftedStack, int experience, int durationTicks) {
            if (this.craftedItemPredicate.isPresent() && !this.craftedItemPredicate.get().test(craftedStack)) {
                return false;
            }
            if (!this.experienceRange.matches(experience)) {
                return false;
            }
            return this.craftingDurationTicksRange.matches(durationTicks);
        }
    }
}

