/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class NaturesStaffConversionCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("natures_staff_conversion");

    public void trigger(ServerPlayer player, BlockState sourceBlockState, BlockState targetBlockState) {
        this.trigger(player, conditions -> conditions.matches(sourceBlockState, targetBlockState));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<Block> sourceBlock, StatePropertiesPredicate sourceBlockState, Optional<Block> targetBlock, StatePropertiesPredicate targetBlockState) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("source_block").forGetter(Conditions::sourceBlock), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("source_state", (Object)new StatePropertiesPredicate(List.of())).forGetter(Conditions::sourceBlockState), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("target_block").forGetter(Conditions::targetBlock), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("target_state", (Object)new StatePropertiesPredicate(List.of())).forGetter(Conditions::targetBlockState)).apply((Applicative)instance, Conditions::new));

        public boolean matches(BlockState sourceBlockState, BlockState targetBlockState) {
            if (this.sourceBlock.isPresent() && !sourceBlockState.is(this.sourceBlock.get())) {
                return false;
            }
            if (!this.sourceBlockState.matches(sourceBlockState)) {
                return false;
            }
            if (this.targetBlock.isPresent() && !targetBlockState.is(this.targetBlock.get())) {
                return false;
            }
            return this.targetBlockState.matches(targetBlockState);
        }
    }
}

