/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DivinityTickCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("divinity_tick");

    public void trigger(ServerPlayer player) {
        this.trigger(player, conditions -> conditions.matches(player.isAlive(), player.getHealth()));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<Boolean> isAlive, MinMaxBounds.Doubles healthRange) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)Codec.BOOL.optionalFieldOf("isAlive").forGetter(Conditions::isAlive), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("healthRange", (Object)MinMaxBounds.Doubles.ANY).forGetter(Conditions::healthRange)).apply((Applicative)instance, Conditions::new));

        public boolean matches(boolean isPlayerAlive, float health) {
            return this.isAlive.isPresent() && isPlayerAlive == this.isAlive.get() && this.healthRange.matches((double)health);
        }
    }
}

