/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class CinderhearthSmeltingCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("cinderhearth_smelting");

    public void trigger(ServerPlayer player, ItemStack input, List<ItemStack> outputs, int experience, Upgradeable.UpgradeHolder upgrades) {
        this.trigger(player, conditions -> conditions.matches(input, outputs, experience, upgrades));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, ItemPredicate input, ItemPredicate output, MinMaxBounds.Ints gainedExperience, MinMaxBounds.Ints speedMultiplier, MinMaxBounds.Ints yieldMultiplier, MinMaxBounds.Ints efficiencyMultiplier, MinMaxBounds.Ints experienceMultiplier) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("input", (Object)ItemPredicate.Builder.item().build()).forGetter(Conditions::input), (App)ItemPredicate.CODEC.optionalFieldOf("output", (Object)ItemPredicate.Builder.item().build()).forGetter(Conditions::output), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("gained_experience", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::gainedExperience), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("speed_multiplier", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::speedMultiplier), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("yield_multiplier", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::yieldMultiplier), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("efficiency_multiplier", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::efficiencyMultiplier), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("experience_multiplier", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::experienceMultiplier)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack input, List<ItemStack> outputs, int experience, Upgradeable.UpgradeHolder upgrades) {
            if (!this.input.test(input)) {
                return false;
            }
            if (!this.gainedExperience.matches(experience)) {
                return false;
            }
            if (!this.speedMultiplier.matches(upgrades.getRawValue(Upgradeable.UpgradeType.SPEED))) {
                return false;
            }
            if (!this.yieldMultiplier.matches(upgrades.getRawValue(Upgradeable.UpgradeType.YIELD))) {
                return false;
            }
            if (!this.efficiencyMultiplier.matches(upgrades.getRawValue(Upgradeable.UpgradeType.EFFICIENCY))) {
                return false;
            }
            if (!this.experienceMultiplier.matches(upgrades.getRawValue(Upgradeable.UpgradeType.EXPERIENCE))) {
                return false;
            }
            if (this.output.equals((Object)ItemPredicate.Builder.item().build())) {
                return true;
            }
            for (ItemStack output : outputs) {
                if (!this.output.test(output)) continue;
                return true;
            }
            return false;
        }
    }
}

