/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.predicate.block.BrokenBlockPredicate;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBrokenCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("block_broken");

    public void trigger(ServerPlayer player, BlockState minedBlock) {
        this.trigger(player, conditions -> conditions.matches(minedBlock));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<BrokenBlockPredicate> blockPredicate) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)BrokenBlockPredicate.CODEC.optionalFieldOf("block").forGetter(Conditions::blockPredicate)).apply((Applicative)instance, Conditions::new));

        public boolean matches(BlockState blockState) {
            if (this.blockPredicate.isEmpty()) {
                return true;
            }
            return this.blockPredicate.get().test(blockState);
        }
    }
}

