/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class TransmissionParticleEffect
implements ParticleOptions {
    public static final MapCodec<TransmissionParticleEffect> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.PARTICLE_TYPE.byNameCodec().fieldOf("particle_type").forGetter(c -> c.particleType), (App)PositionSource.CODEC.fieldOf("destination").forGetter(c -> c.destination), (App)Codec.INT.fieldOf("arrival_in_ticks").forGetter(c -> c.arrivalInTicks)).apply((Applicative)i, TransmissionParticleEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TransmissionParticleEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.PARTICLE_TYPE), c -> c.particleType, (StreamCodec)PositionSource.STREAM_CODEC, c -> c.destination, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.arrivalInTicks, TransmissionParticleEffect::new);
    protected final ParticleType<?> particleType;
    protected final PositionSource destination;
    protected final int arrivalInTicks;

    public TransmissionParticleEffect(ParticleType<?> particleType, PositionSource positionSource, int arrivalInTicks) {
        this.particleType = particleType;
        this.destination = positionSource;
        this.arrivalInTicks = arrivalInTicks;
    }

    public PositionSource getDestination() {
        return this.destination;
    }

    public int getArrivalInTicks() {
        return this.arrivalInTicks;
    }

    public ParticleType<?> getType() {
        return this.particleType;
    }

    public String toString() {
        Optional pos = this.destination.getPosition(null);
        if (pos.isPresent()) {
            double d = ((Vec3)pos.get()).x();
            double e = ((Vec3)pos.get()).y();
            double f = ((Vec3)pos.get()).z();
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %d", BuiltInRegistries.PARTICLE_TYPE.getKey(this.getType()), d, e, f, this.arrivalInTicks);
        }
        return String.format(Locale.ROOT, "%s <no destination> %d", BuiltInRegistries.PARTICLE_TYPE.getKey(this.getType()), this.arrivalInTicks);
    }
}

