/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class RainRippleParticle
extends TextureSheetParticle {
    private float width;
    private float lastWidth;
    private float alphaMult;

    public RainRippleParticle(ClientLevel clientWorld, double d, double e, double f, SpriteSet spriteProvider) {
        super(clientWorld, d, e, f);
        this.pickSprite(spriteProvider);
        this.gravity = 0.0f;
        this.quadSize = 0.2f + this.random.nextFloat() * 0.1f;
        this.alpha = this.alphaMult = 0.75f + this.random.nextFloat() * 0.25f;
        Vector3f waterColor = ColorHelper.colorIntToVec(BiomeColors.getAverageWaterColor((BlockAndTintGetter)this.level, (BlockPos)BlockPos.containing((double)this.x, (double)this.y, (double)this.z)));
        this.rCol = waterColor.x;
        this.gCol = waterColor.y;
        this.bCol = waterColor.z;
        this.lifetime = 13;
    }

    public void tick() {
        this.lastWidth = this.width;
        this.width = Math.max(0.05f, (float)this.age / 13.0f) + 0.1f;
        this.adjustAlpha();
        super.tick();
    }

    private void adjustAlpha() {
        this.alpha = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, 6) / 6.0f), (float)0.0f, (float)this.alphaMult);
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.getPosition();
        float f = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - vec3d.x());
        float g = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - vec3d.y());
        float h = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - vec3d.z());
        float effWidth = Mth.lerp((float)tickDelta, (float)this.lastWidth, (float)this.width);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-effWidth, 0.0f, -effWidth), new Vector3f(-effWidth, 0.0f, effWidth), new Vector3f(effWidth, 0.0f, effWidth), new Vector3f(effWidth, 0.0f, -effWidth)};
        float i = this.getQuadSize(tickDelta);
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f = vector3fs[j];
            vector3f.mul(i);
            vector3f.add(f, g, h);
        }
        float k = this.getU0();
        float l = this.getU1();
        float m = this.getV0();
        float n = this.getV1();
        int o = this.getLightColor(tickDelta);
        vertexConsumer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(l, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
        vertexConsumer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(l, m).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
        vertexConsumer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(k, m).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
        vertexConsumer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(k, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new RainRippleParticle(clientWorld, d, e, f, this.spriteProvider);
        }
    }
}

