/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.particle.client.TransmissionParticle;
import earth.terrarium.pastel.particle.render.EarlyRenderingParticle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class PastelTransmissionParticle
extends TransmissionParticle
implements EarlyRenderingParticle {
    private final ItemRenderer itemRenderer;
    private final List<Vec3> travelPositions;
    private final ItemStack itemStack;
    private final ParticleOptions particleEffect;

    public PastelTransmissionParticle(ItemRenderer itemRenderer, ClientLevel world, double x, double y, double z, List<BlockPos> travelPositions, ItemStack stack, int travelTime, int networkColor) {
        super(world, x, y, z, (PositionSource)new BlockPositionSource(travelPositions.get(travelPositions.size() - 1)), travelTime);
        this.itemRenderer = itemRenderer;
        this.itemStack = stack;
        this.quadSize = 0.25f;
        this.particleEffect = new DustParticleOptions(ColorHelper.colorIntToVec(networkColor), 0.8f);
        this.travelPositions = new ArrayList<Vec3>();
        for (BlockPos p : travelPositions) {
            this.travelPositions.add(Vec3.atCenterOf((Vec3i)p));
        }
        Vec3 startPos = this.travelPositions.get(0);
        world.playLocalSound(startPos.x(), startPos.y() + 0.25, startPos.z(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.15f * PastelCommon.CONFIG.BlockSoundVolume + world.random.nextFloat() / 10.0f, 0.8f + world.random.nextFloat() * 0.3f, true);
        world.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, startPos.x(), startPos.y() + 0.25, startPos.z(), 0.0, 0.0, 0.0);
    }

    @Override
    public void tick() {
        ++this.age;
        int vertexCount = this.travelPositions.size() - 1;
        float travelPercent = (float)this.age / (float)this.lifetime;
        if (travelPercent >= 1.0f) {
            Vec3 destination = this.travelPositions.get(vertexCount);
            this.level.playLocalSound(destination.x(), destination.y() + 0.25, destination.z(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.1f * PastelCommon.CONFIG.BlockSoundVolume + this.random.nextFloat() / 10.0f, 0.6f + this.level.random.nextFloat() * 0.3f, true);
            this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, destination.x(), destination.y() + 0.25, destination.z(), 0.0, 0.0, 0.0);
            this.remove();
            return;
        }
        float progress = travelPercent * (float)vertexCount;
        int startNodeID = (int)progress;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        Vec3 source = this.travelPositions.get(startNodeID);
        Vec3 destination = this.travelPositions.get(startNodeID + 1);
        float nodeProgress = progress % 1.0f;
        this.x = Mth.lerp((double)nodeProgress, (double)source.x, (double)destination.x);
        this.y = Mth.lerp((double)nodeProgress, (double)source.y, (double)destination.y);
        this.z = Mth.lerp((double)nodeProgress, (double)source.z, (double)destination.z);
    }

    @Override
    public void renderAsEntity(PoseStack poseStack, MultiBufferSource vertexConsumers, Camera camera, float tickDelta) {
        Vec3 cameraPos = camera.getPosition();
        float x = (float)Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x);
        float y = (float)Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y);
        float z = (float)Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z);
        double xOffset = (double)x - cameraPos.x;
        double zOffset = (double)z - cameraPos.z;
        Quaternionf rot = Axis.YP.rotation((float)Mth.atan2((double)xOffset, (double)zOffset));
        poseStack.pushPose();
        poseStack.translate((double)x - cameraPos.x, (double)y - cameraPos.y, (double)z - cameraPos.z);
        int light = this.getLightColor(tickDelta);
        poseStack.mulPose(rot);
        poseStack.translate(0.0, -0.15, 0.0);
        this.itemRenderer.renderStatic(this.itemStack, ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, poseStack, vertexConsumers, (Level)this.level, 0);
        poseStack.popPose();
    }
}

