/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LightTrailParticle
extends SimpleAnimatedParticle {
    protected LightTrailParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, 0.0f);
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
        this.quadSize = 0.2f;
        this.lifetime = 25;
        this.setSpriteFromAge(spriteProvider);
        this.setAlpha(0.8f);
        this.setFadeColor(11057919);
    }

    public void tick() {
        super.tick();
        float fadeProgress = Mth.clamp((float)(((float)this.age + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false)) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        this.setAlpha(Mth.lerp((float)fadeProgress, (float)0.8f, (float)0.0f));
        this.quadSize = Mth.lerp((float)fadeProgress, (float)0.2f, (float)0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new LightTrailParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

