/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.deeper_down.HowlingSpireEffects;
import earth.terrarium.pastel.registries.PastelBiomes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FallingAshParticle
extends TextureSheetParticle {
    private static final Vec3 VERTICAL = new Vec3(0.0, 1.0, 0.0);
    private static final float GRAVITY = 0.15f;
    private static double targetVelocity = 0.215;
    private static double ashScaleA = 20000.0;
    private static double ashScaleB = 2200.0;
    private static double ashScaleC = 200.0;
    private static Direction.Axis primaryAxis;
    private static Direction.Axis lastAxis;
    private final float rotateFactor;
    private final float lightness;
    private final int simInterval;
    private final int simOffset;
    private int slowTicks;
    private int axisTicks;
    private static final BlockPos.MutableBlockPos pos;

    protected FallingAshParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(clientWorld, x, y, z);
        this.simInterval = PastelCommon.CONFIG.WindSimInterval;
        this.axisTicks = 0;
        this.pickSprite(spriteProvider);
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
        RandomSource random = clientWorld.getRandom();
        this.hasPhysics = true;
        this.gravity = 0.15f;
        this.lifetime = 150 + random.nextInt(50);
        this.rotateFactor = ((float)Math.random() - 0.5f) * 0.002f;
        this.quadSize = (float)(0.06 + random.nextDouble() / 14.0);
        this.lightness = random.nextFloat() * 0.6f + 0.4f;
        this.simOffset = random.nextInt(this.simInterval);
        this.setAlpha(0.0f);
    }

    public void tick() {
        pos.set(this.x, this.y, this.z);
        Vec3 camPos = Minecraft.getInstance().getCameraEntity().position();
        double distance = Math.sqrt(camPos.distanceToSqr(this.x, this.y, this.z));
        if (distance > (double)(HowlingSpireEffects.getRenderRadius() - 1)) {
            this.remove();
            return;
        }
        this.oRoll = this.roll;
        boolean water = !this.level.getFluidState((BlockPos)pos).isEmpty();
        long time = this.level.getGameTime() % 432000L;
        if (this.age + 2 < this.lifetime && this.level.getBiome((BlockPos)pos).is(PastelBiomes.HOWLING_SPIRES)) {
            ++this.age;
        }
        if (lastAxis != primaryAxis) {
            lastAxis = primaryAxis;
            this.axisTicks = 0;
        }
        switch (primaryAxis) {
            case X: {
                this.xd = Mth.clampedLerp((double)this.xd, (double)this.adjustVelocity(this.xd, water), (double)((float)this.axisTicks / 20.0f));
                this.zd = Mth.clampedLerp((double)this.zd, (double)FallingAshParticle.getNonPrimaryVelocity(time), (double)((float)this.axisTicks / 20.0f));
                break;
            }
            case Z: {
                this.zd = Mth.clampedLerp((double)this.zd, (double)this.adjustVelocity(this.zd, water), (double)((float)this.axisTicks / 20.0f));
                this.xd = Mth.clampedLerp((double)this.xd, (double)FallingAshParticle.getNonPrimaryVelocity(time), (double)((float)this.axisTicks / 20.0f));
            }
        }
        if (this.axisTicks < 20) {
            ++this.axisTicks;
        }
        if (Math.abs(this.xd) + Math.abs(this.zd) < 0.1) {
            if (this.slowTicks < 20) {
                ++this.slowTicks;
            }
        } else {
            this.slowTicks = 0;
        }
        if (!this.onGround && !water) {
            this.roll += (float)(Math.PI * Math.sin(this.rotateFactor * (float)this.age) / 2.0);
            if (this.verifySimConfig(time)) {
                this.adjustGravityForLift();
            }
        } else if (water) {
            this.yd /= 4.0;
            this.xd /= 4.0;
            this.zd /= 4.0;
            this.gravity = 0.0f;
        } else {
            this.gravity = 0.15f;
        }
        this.adjustAlpha(water);
        if (this.verifySimConfig(time) && Math.abs(this.xd) + Math.abs(this.zd) > 0.125) {
            this.applyAirflowTransforms();
        }
        super.tick();
    }

    private boolean verifySimConfig(long time) {
        return PastelCommon.CONFIG.WindSim && (time + (long)this.simOffset) % (long)this.simInterval == 0L;
    }

    private void adjustGravityForLift() {
        float height;
        boolean groundFound = false;
        for (height = 0.0f; height < 20.0f; height += 1.0f) {
            pos.move(Direction.DOWN);
            if (!this.level.getFluidState((BlockPos)pos).isEmpty()) {
                this.gravity = 0.0f;
                return;
            }
            if (!this.level.getBlockState((BlockPos)pos).isFaceSturdy((BlockGetter)this.level, (BlockPos)pos, Direction.UP)) continue;
            groundFound = true;
            break;
        }
        height += (float)(this.y - (double)((int)this.y));
        if (!groundFound) {
            this.gravity = 0.3f * (1.0f + (1.0f - this.lightness));
            return;
        }
        float heightFactor = height / 14.0f;
        if (height < 4.0f) {
            this.gravity = 0.15f - 0.15f * (1.0f - heightFactor * 2.0f) * 2.0f * this.lightness;
            return;
        }
        if (height > 14.0f) {
            this.gravity = 0.15f * (1.0f - (height - 14.0f) / 7.0f) * 0.225f;
            return;
        }
        this.gravity = 0.15f * heightFactor;
    }

    private void applyAirflowTransforms() {
        Vec3 velocity = new Vec3(this.xd, this.yd, this.zd);
        Vec3 direction = velocity.normalize();
        Vec3 movementNormal = direction.cross(VERTICAL);
        for (int i = 0; i <= 6; ++i) {
            float deflection = -0.0125f * (1.0f - (float)i / 24.0f) * this.lightness * (float)this.simInterval;
            Vec3 shift = velocity.scale((double)i).add(this.x, this.y, this.z);
            int maxDist = 6 - i;
            for (int orthogonal = 1; orthogonal <= maxDist; ++orthogonal) {
                Vec3 collisionDirection;
                Vec3 leftShift = movementNormal.scale((double)orthogonal).add(shift);
                Vec3 rightShift = movementNormal.scale((double)(-orthogonal)).add(shift);
                BlockPos leftPos = new BlockPos((int)leftShift.x, (int)leftShift.y, (int)leftShift.z);
                BlockPos rightPos = new BlockPos((int)rightShift.x, (int)rightShift.y, (int)rightShift.z);
                if (this.level.getBlockState(leftPos).isRedstoneConductor((BlockGetter)this.level, leftPos)) {
                    collisionDirection = leftShift.subtract(this.x, this.y, this.z).normalize();
                    this.xd += collisionDirection.x * (double)deflection;
                    this.zd += collisionDirection.z * (double)deflection;
                }
                if (!this.level.getBlockState(rightPos).isRedstoneConductor((BlockGetter)this.level, rightPos)) continue;
                collisionDirection = rightShift.subtract(this.x, this.y, this.z).normalize();
                this.xd += collisionDirection.x * (double)deflection;
                this.zd += collisionDirection.z * (double)deflection;
            }
        }
    }

    private static double getNonPrimaryVelocity(long time) {
        double scale = Math.sin((double)time / ashScaleA + ashScaleB);
        scale *= Math.cos((double)time / ashScaleB + ashScaleC) / 2.0;
        scale *= Math.cos((double)time / ashScaleC + ashScaleA) / 4.0;
        return scale *= 2.0;
    }

    private void adjustAlpha(boolean water) {
        if (this.age <= 20) {
            this.alpha = Mth.clamp((float)((float)this.age / 20.0f), (float)0.0f, (float)1.0f);
            return;
        }
        float ageFade = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, 40) / 40.0f), (float)0.0f, (float)1.0f);
        this.alpha = ageFade < 1.0f ? Math.min(this.alpha, ageFade) : (this.onGround || this.slowTicks == 20 ? Mth.clamp((float)(this.alpha - 0.02f), (float)0.0f, (float)1.0f) : (water ? Mth.clamp((float)(this.alpha - 0.02f), (float)0.5f, (float)1.0f) : Mth.clamp((float)(this.alpha + 0.05f), (float)0.0f, (float)1.0f)));
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    private double adjustVelocity(double velocity, boolean water) {
        if (water) {
            return velocity / 1.5;
        }
        if (velocity != targetVelocity && velocity >= targetVelocity - 0.15 && velocity <= targetVelocity + 0.15) {
            velocity = targetVelocity;
        } else if (velocity > targetVelocity) {
            velocity -= 0.125;
        } else if (velocity < targetVelocity) {
            velocity += 0.0334;
        }
        return velocity;
    }

    public static void setTargetVelocity(double targetVelocity) {
        FallingAshParticle.targetVelocity = targetVelocity;
    }

    public static void setPrimaryAxis(Direction.Axis primaryAxis) {
        FallingAshParticle.primaryAxis = primaryAxis;
    }

    public static void setAshScaleA(double ashScaleA) {
        FallingAshParticle.ashScaleA = ashScaleA;
    }

    public static void setAshScaleB(double ashScaleB) {
        FallingAshParticle.ashScaleB = ashScaleB;
    }

    public static void setAshScaleC(double ashScaleC) {
        FallingAshParticle.ashScaleC = ashScaleC;
    }

    public int getLightColor(float tint) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    static {
        lastAxis = primaryAxis = Direction.Axis.X;
        pos = new BlockPos.MutableBlockPos();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new FallingAshParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

