/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AzureAuraParticle
extends RisingParticle {
    private final float alphaMult;
    private float length;

    protected AzureAuraParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
        this.lifetime = 160 + this.random.nextInt(140);
        this.quadSize = 0.3f;
        float thisLength = 2.0f + this.random.nextFloat() * 2.0f;
        this.quadSize += thisLength / 14.0f;
        this.quadSize *= this.random.nextFloat() * 0.75f + 0.25f;
        this.length = thisLength * (this.random.nextFloat() * 0.75f + 0.25f);
        this.yd += (double)(this.length / 100.0f);
        this.alpha = 0.0f;
        this.hasPhysics = false;
        this.alphaMult = this.random.nextFloat() * 0.5f + 0.5f;
        this.bCol = 1.0f;
        this.rCol = 0.15f * this.random.nextFloat();
        this.gCol = 0.3f + this.random.nextFloat() * 0.55f;
        this.friction = 1.0f;
    }

    public void tick() {
        this.adjustAlpha();
        super.tick();
    }

    private void adjustAlpha() {
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.age <= 20) {
            this.alpha = Mth.clamp((float)((float)this.age / 20.0f), (float)0.0f, (float)this.alphaMult);
            return;
        }
        int fadeMarker = Math.min(this.lifetime / 5 * 2, 40);
        float ageFade = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, fadeMarker) / (float)fadeMarker), (float)0.0f, (float)this.alphaMult);
        this.alpha = ageFade < this.alphaMult ? Math.min(this.alpha, ageFade) : (!this.level.getBlockState(pos).propagatesSkylightDown((BlockGetter)this.level, pos) ? Mth.clamp((float)(this.alpha - 0.06f), (float)(this.alphaMult / 10.0f), (float)this.alphaMult) : Mth.clamp((float)(this.alpha + 0.0325f), (float)0.0f, (float)this.alphaMult));
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 cameraPos = camera.getPosition();
        float xOff = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - cameraPos.x());
        float yOff = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - cameraPos.y());
        float zOff = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - cameraPos.z());
        float size = this.getQuadSize(tickDelta);
        float rot = (float)Mth.atan2((double)xOff, (double)zOff);
        float sin = org.joml.Math.sin((float)rot);
        float cos = org.joml.Math.cosFromSin((float)sin, (float)rot);
        float negX = Math.fma(-cos, size, xOff);
        float posX = Math.fma(cos, size, xOff);
        float negY = Math.fma(-this.length, size, yOff);
        float posY = Math.fma(this.length, size, yOff);
        float negZ = Math.fma(-sin, size, zOff);
        float posZ = Math.fma(sin, size, zOff);
        float minU = this.getU0();
        float maxU = this.getU1();
        float minV = this.getV0();
        float maxV = this.getV1();
        int brightness = this.getLightColor(tickDelta);
        vertexConsumer.addVertex(negX, negY, posZ).setUv(maxU, maxV).setColor(this.rCol, this.gCol, this.bCol, 0.0f).setLight(brightness);
        vertexConsumer.addVertex(negX, posY, posZ).setUv(maxU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(brightness);
        vertexConsumer.addVertex(posX, posY, negZ).setUv(minU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(brightness);
        vertexConsumer.addVertex(posX, negY, negZ).setUv(minU, maxV).setColor(this.rCol, this.gCol, this.bCol, 0.0f).setLight(brightness);
    }

    public int getLightColor(float tint) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            AzureAuraParticle particle = new AzureAuraParticle(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            particle.pickSprite(this.spriteProvider);
            return particle;
        }
    }
}

