/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateBlockEntityInkPayload(BlockPos pos, Map<InkColor, Long> storage, long currentTotal) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateBlockEntityInkPayload> ID = PastelC2SPackets.makeId("update_block_entity_ink");
    public static final StreamCodec<FriendlyByteBuf, UpdateBlockEntityInkPayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateBlockEntityInkPayload::pos, (StreamCodec)ByteBufCodecs.map(HashMap::new, InkColor.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_LONG), UpdateBlockEntityInkPayload::storage, (StreamCodec)ByteBufCodecs.VAR_LONG, UpdateBlockEntityInkPayload::currentTotal, UpdateBlockEntityInkPayload::new);

    public static void updateBlockEntityInk(BlockPos pos, InkStorage inkStorage, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateBlockEntityInkPayload(pos, inkStorage.getEnergy(), inkStorage.getCurrentTotal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(UpdateBlockEntityInkPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        BlockEntity blockEntity = level.getBlockEntity(payload.pos);
        if (blockEntity instanceof InkStorageBlockEntity) {
            InkStorageBlockEntity inkStorageBlockEntity = (InkStorageBlockEntity)blockEntity;
            inkStorageBlockEntity.getEnergyStorage().setEnergy(payload.storage, payload.currentTotal);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

