/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.present.PresentBlock;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayPresentOpeningParticlesPayload(BlockPos presentPos, Map<Integer, Integer> colors) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayPresentOpeningParticlesPayload> ID = PastelC2SPackets.makeId("play_present_opening_particles");
    public static final StreamCodec<FriendlyByteBuf, PlayPresentOpeningParticlesPayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PlayPresentOpeningParticlesPayload::presentPos, (StreamCodec)ByteBufCodecs.map(Object2IntArrayMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ByteBufCodecs.INT), PlayPresentOpeningParticlesPayload::colors, PlayPresentOpeningParticlesPayload::new);

    public static void playPresentOpeningParticles(ServerLevel serverWorld, BlockPos presentPos, Map<Integer, Integer> colors) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverWorld, (ChunkPos)new ChunkPos(presentPos), (CustomPacketPayload)new PlayPresentOpeningParticlesPayload(presentPos, colors), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayPresentOpeningParticlesPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        PresentBlock.spawnParticles(level, payload.presentPos, payload.colors);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

