/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PlayParticleWithExactVelocityPayload(Vec3 pos, ParticleOptions particle, int amount, Vec3 velocity) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayParticleWithExactVelocityPayload> ID = PastelC2SPackets.makeId("play_particle_with_exact_velocity");
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayParticleWithExactVelocityPayload> CODEC = StreamCodec.composite(PacketCodecHelper.VEC3D, PlayParticleWithExactVelocityPayload::pos, (StreamCodec)ParticleTypes.STREAM_CODEC, PlayParticleWithExactVelocityPayload::particle, (StreamCodec)ByteBufCodecs.INT, PlayParticleWithExactVelocityPayload::amount, PacketCodecHelper.VEC3D, PlayParticleWithExactVelocityPayload::velocity, PlayParticleWithExactVelocityPayload::new);

    public static void playParticles(ServerLevel world, BlockPos position, ParticleOptions particleEffect, int amount) {
        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity(world, Vec3.atCenterOf((Vec3i)position), particleEffect, amount, Vec3.ZERO);
    }

    public static void playParticleWithExactVelocity(ServerLevel world, @NotNull Vec3 position, @NotNull ParticleOptions particleEffect, int amount, @NotNull Vec3 velocity) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(BlockPos.containing((Position)position)), (CustomPacketPayload)new PlayParticleWithExactVelocityPayload(position, particleEffect, amount, velocity), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayParticleWithExactVelocityPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        for (int i = 0; i < payload.amount; ++i) {
            level.addParticle(payload.particle, payload.pos.x(), payload.pos.y(), payload.pos.z(), payload.velocity.x(), payload.velocity.y(), payload.velocity.z());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

