/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.helpers.render.ParticleHelper;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.VectorPattern;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayDivinityAppliedEffectsPayload() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayDivinityAppliedEffectsPayload> ID = PastelC2SPackets.makeId("play_divinity_applied_effects");
    public static final StreamCodec<FriendlyByteBuf, PlayDivinityAppliedEffectsPayload> CODEC = StreamCodec.of((buf, value) -> {}, buf -> new PlayDivinityAppliedEffectsPayload());

    public static void playDivinityAppliedEffects(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayDivinityAppliedEffectsPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayDivinityAppliedEffectsPayload payload, IPayloadContext context) {
        PlayDivinityAppliedEffectsPayload.execute(context.player());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void execute(Player player) {
        Level level = player.level();
        Minecraft client = Minecraft.getInstance();
        client.particleEngine.createTrackingEmitter((Entity)player, (ParticleOptions)PastelParticleTypes.DIVINITY, 30);
        client.gameRenderer.displayItemActivation(((Item)PastelItems.DIVINATION_HEART.get()).getDefaultInstance());
        level.playSound(null, player.blockPosition(), PastelSounds.FAILING_PLACED, SoundSource.PLAYERS, 1.0f, 1.0f);
        ParticleHelper.playParticleWithPatternAndVelocityClient(level, player.position(), ColoredCraftingParticleEffect.WHITE, VectorPattern.SIXTEEN, 0.4);
        ParticleHelper.playParticleWithPatternAndVelocityClient(level, player.position(), ColoredCraftingParticleEffect.RED, VectorPattern.SIXTEEN, 0.4);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

