/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.sound.CraftingBlockSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PlayBlockBoundSoundInstancePayload(SoundEvent soundEvent, BlockPos pos, Holder<Block> block, int maxDurationTicks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayBlockBoundSoundInstancePayload> ID = PastelC2SPackets.makeId("play_block_bound_sound_instance");
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayBlockBoundSoundInstancePayload> CODEC = StreamCodec.composite((StreamCodec)SoundEvent.DIRECT_STREAM_CODEC, PlayBlockBoundSoundInstancePayload::soundEvent, (StreamCodec)BlockPos.STREAM_CODEC, PlayBlockBoundSoundInstancePayload::pos, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.BLOCK), PlayBlockBoundSoundInstancePayload::block, (StreamCodec)ByteBufCodecs.INT, PlayBlockBoundSoundInstancePayload::maxDurationTicks, PlayBlockBoundSoundInstancePayload::new);

    public static void sendPlayBlockBoundSoundInstance(SoundEvent soundEvent, @NotNull ServerLevel world, BlockPos pos, int maxDurationTicks) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new PlayBlockBoundSoundInstancePayload(soundEvent, pos, (Holder<Block>)world.getBlockState(pos).getBlock().builtInRegistryHolder(), maxDurationTicks), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendCancelBlockBoundSoundInstance(@NotNull ServerLevel world, BlockPos pos) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new PlayBlockBoundSoundInstancePayload(SoundEvents.EMPTY, pos, (Holder<Block>)world.getBlockState(pos).getBlock().builtInRegistryHolder(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayBlockBoundSoundInstancePayload payload, IPayloadContext context) {
        if (payload.maxDurationTicks < 0) {
            CraftingBlockSoundInstance.stopPlayingOnPos(payload.pos);
        } else {
            CraftingBlockSoundInstance.startSoundInstance(payload.soundEvent, payload.pos, (Block)payload.block.value(), payload.maxDurationTicks);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

