/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PastelNodeStatusUpdatePayload(boolean longSpin, Map<BlockPos, Integer> spinTimes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PastelNodeStatusUpdatePayload> ID = PastelC2SPackets.makeId("pastel_node_status_update");
    public static final StreamCodec<FriendlyByteBuf, PastelNodeStatusUpdatePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PastelNodeStatusUpdatePayload::longSpin, (StreamCodec)ByteBufCodecs.map(Object2IntArrayMap::new, (StreamCodec)BlockPos.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), PastelNodeStatusUpdatePayload::spinTimes, PastelNodeStatusUpdatePayload::new);

    public static void sendPastelNodeStatusUpdate(List<PastelNodeBlockEntity> nodes, boolean longSpin) {
        Object2IntArrayMap spinTimes = new Object2IntArrayMap();
        for (PastelNodeBlockEntity node : nodes) {
            Level world = node.getLevel();
            if (world == null) continue;
            int time = longSpin ? 24 + world.getRandom().nextInt(11) : 10 + world.getRandom().nextInt(11);
            spinTimes.put(node.getBlockPos(), time);
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)nodes.getFirst().getLevel()), (ChunkPos)new ChunkPos(nodes.getFirst().getBlockPos()), (CustomPacketPayload)new PastelNodeStatusUpdatePayload(longSpin, (Map<BlockPos, Integer>)spinTimes), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PastelNodeStatusUpdatePayload payload, IPayloadContext context) {
        Level level = context.player().level();
        for (Map.Entry<BlockPos, Integer> e : payload.spinTimes.entrySet()) {
            BlockEntity entity = level.getBlockEntity(e.getKey());
            if (!(entity instanceof PastelNodeBlockEntity)) continue;
            PastelNodeBlockEntity node = (PastelNodeBlockEntity)entity;
            node.setSpinTicks(e.getValue().intValue());
            if (!payload.longSpin || !node.isTriggerTransfer()) continue;
            node.markTriggered();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

