/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.api.block.InkColorSelectedPacketReceiver;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record InkColorSelectedS2CPayload(Optional<Holder<InkColor>> inkColor) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InkColorSelectedS2CPayload> ID = PastelC2SPackets.makeId("ink_color_selected");
    public static final StreamCodec<RegistryFriendlyByteBuf, InkColorSelectedS2CPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)PastelRegistries.INK_COLOR.key())), InkColorSelectedS2CPayload::inkColor, InkColorSelectedS2CPayload::new);

    public static void sendInkColorSelected(Optional<Holder<InkColor>> inkColor, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new InkColorSelectedS2CPayload(inkColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(InkColorSelectedS2CPayload payload, IPayloadContext context) {
        AbstractContainerMenu screenHandler = context.player().containerMenu;
        if (screenHandler instanceof InkColorSelectedPacketReceiver) {
            InkColorSelectedPacketReceiver inkColorSelectedPacketReceiver = (InkColorSelectedPacketReceiver)screenHandler;
            inkColorSelectedPacketReceiver.onInkColorSelectedPacket(payload.inkColor());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

