/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.particle.effect.ColoredTransmission;
import earth.terrarium.pastel.particle.effect.ColoredTransmissionParticleEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ColorTransmissionPayload(BlockPos pos, ColoredTransmission transmission) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ColorTransmissionPayload> ID = PastelC2SPackets.makeId("color_transmission");
    public static final StreamCodec<RegistryFriendlyByteBuf, ColorTransmissionPayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ColorTransmissionPayload::pos, ColoredTransmission.STREAM_CODEC, ColorTransmissionPayload::transmission, ColorTransmissionPayload::new);

    public static void playColorTransmissionParticle(ServerLevel world, @NotNull ColoredTransmission transmission) {
        BlockPos pos = BlockPos.containing((Position)transmission.getOrigin());
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new ColorTransmissionPayload(pos, transmission), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(ColorTransmissionPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        ColoredTransmission transmission = payload.transmission;
        level.addAlwaysVisibleParticle((ParticleOptions)new ColoredTransmissionParticleEffect(transmission.getDestination(), transmission.getArrivalInTicks(), transmission.getDyeColor()), true, transmission.getOrigin().x(), transmission.getOrigin().y(), transmission.getOrigin().z(), 0.0, 0.0, 0.0);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

