/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.c2s_payloads;

import earth.terrarium.pastel.api.block.FilterConfigurable;
import earth.terrarium.pastel.inventories.slots.ShadowSlot;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record SetShadowSlotPayload(int screenHandlerSyncId, int slotId, ItemStack shadowStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetShadowSlotPayload> ID = PastelC2SPackets.makeId("set_shadow_slot");
    public static final StreamCodec<RegistryFriendlyByteBuf, SetShadowSlotPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SetShadowSlotPayload::screenHandlerSyncId, (StreamCodec)ByteBufCodecs.INT, SetShadowSlotPayload::slotId, (StreamCodec)ItemStack.STREAM_CODEC, SetShadowSlotPayload::shadowStack, SetShadowSlotPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static IPayloadHandler<SetShadowSlotPayload> getPayloadHandler() {
        return (payload, context) -> {
            Container patt0$temp;
            ServerPlayer player = (ServerPlayer)context.player();
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (screenHandler == null || screenHandler.containerId != payload.screenHandlerSyncId) {
                return;
            }
            Slot slot = screenHandler.getSlot(payload.slotId);
            if (slot == null || !(slot instanceof ShadowSlot) || !((patt0$temp = slot.container) instanceof FilterConfigurable.FilterInventory)) {
                return;
            }
            FilterConfigurable.FilterInventory filterInventory = (FilterConfigurable.FilterInventory)patt0$temp;
            filterInventory.getClicker().clickShadowSlot(screenHandler.containerId, slot, payload.shadowStack());
        };
    }
}

