/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.c2s_payloads;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.inventories.BedrockAnvilScreenHandler;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record AddLoreBedrockAnvilPayload(String lore) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AddLoreBedrockAnvilPayload> ID = PastelC2SPackets.makeId("add_lore_to_item_in_bedrock_anvil");
    public static final StreamCodec<FriendlyByteBuf, AddLoreBedrockAnvilPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AddLoreBedrockAnvilPayload::lore, AddLoreBedrockAnvilPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static IPayloadHandler<AddLoreBedrockAnvilPayload> getPayloadHandler() {
        return (payload, context) -> {
            AbstractContainerMenu patt0$temp = context.player().containerMenu;
            if (patt0$temp instanceof BedrockAnvilScreenHandler) {
                BedrockAnvilScreenHandler bedrockAnvilScreenHandler = (BedrockAnvilScreenHandler)patt0$temp;
                if (!bedrockAnvilScreenHandler.stillValid(context.player())) {
                    PastelCommon.LOGGER.debug("Player {} interacted with invalid menu {} while setting lore", (Object)context.player(), (Object)bedrockAnvilScreenHandler);
                }
                bedrockAnvilScreenHandler.setNewItemLore(payload.lore());
            }
        };
    }
}

