/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin.client;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLanguage.class})
public class TranslationStorageMixin {
    @Mutable
    @Shadow
    @Final
    private Map<String, String> storage;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void addTranslations(Map<String, String> translations, boolean rightToLeft, CallbackInfo ci) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) != 3 || calendar.get(5) != 1) {
            return;
        }
        HashMap<String, String> builder = new HashMap<String, String>(translations);
        builder.put("block.pastel.crystallarieum", TranslationStorageMixin.getCrystallarieuaeuieueum());
        builder.put("item.pastel.ring_of_pursuit", "Ring of Fursuit");
        builder.put("item.pastel.draconic_twinsword", "Draconic Winblade");
        builder.put("item.pastel.dragon_talon", "Sellsword Winblades");
        builder.put("effect.pastel.fatal_slumber", "Fat Slumber");
        builder.put("item.pastel.oblivion_pickaxe", "Oblivious Pickaxe");
        builder.put("item.pastel.shimmerstone_gem", "Stimmerstone Gem");
        builder.put("block.pastel.shimmerstone_block", "Block of Stimmerstone");
        builder.put("block.pastel.amethyst_glass_arrow", "Chlorophyte Bullet");
        builder.put("item.pastel.mermaids_gem", translations.get("item.pastel.storm_stone"));
        builder.put("item.pastel.storm_stone", translations.get("item.pastel.mermaids_gem"));
        this.storage = builder;
    }

    @Unique
    private static String getCrystallarieuaeuieueum() {
        ArrayList<String> possibilities = new ArrayList<String>(){
            {
                this.add("Crystallarieum");
                this.add("Crystallareium");
                this.add("Crystallerium");
                this.add("Crystallarium");
                this.add("Crystallium");
                this.add("Crystalleium");
                this.add("Crystallum");
                this.add("Crystallarieium");
                this.add("Christalerium");
            }
        };
        char c = Minecraft.getInstance().getUser().getName().toCharArray()[0];
        return (String)possibilities.get(c % possibilities.size());
    }
}

