/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScreenEffectRenderer.class})
public class InGameOverlayRendererMixin {
    @Inject(method={"renderScreenEffect"}, at={@At(value="HEAD")})
    private static void renderPrimordialFire(Minecraft client, PoseStack matrices, CallbackInfo ci) {
        if (!client.player.isSpectator() && PrimordialFireData.isOnPrimordialFire((LivingEntity)client.player)) {
            InGameOverlayRendererMixin.renderPrimordialFireOverlay(client, matrices);
        }
    }

    @Inject(method={"renderFire"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelFireOverlayWithPrimordialFire(Minecraft client, PoseStack matrices, CallbackInfo ci) {
        if (PrimordialFireData.isOnPrimordialFire((LivingEntity)client.player)) {
            ci.cancel();
        }
    }

    @Unique
    private static void renderPrimordialFireOverlay(Minecraft client, PoseStack matrices) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        TextureAtlasSprite sprite = (TextureAtlasSprite)client.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(PastelCommon.locate("block/primordial_fire_1"));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        float f = sprite.getU0();
        float g = sprite.getU1();
        float h = (f + g) / 2.0f;
        float i = sprite.getV0();
        float j = sprite.getV1();
        float k = (i + j) / 2.0f;
        float l = sprite.uvShrinkRatio();
        float m = Mth.lerp((float)l, (float)f, (float)h);
        float n = Mth.lerp((float)l, (float)g, (float)h);
        float o = Mth.lerp((float)l, (float)i, (float)k);
        float p = Mth.lerp((float)l, (float)j, (float)k);
        for (int r = 0; r < 2; ++r) {
            matrices.pushPose();
            matrices.translate((float)(-(r * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            matrices.mulPose(Axis.YP.rotationDegrees((float)(r * 2 - 1) * 10.0f));
            Matrix4f matrix4f = matrices.last().pose();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferBuilder.addVertex(matrix4f, -0.5f, -0.5f, -0.5f).setUv(n, p).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferBuilder.addVertex(matrix4f, 0.5f, -0.5f, -0.5f).setUv(m, p).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferBuilder.addVertex(matrix4f, 0.5f, 0.5f, -0.5f).setUv(m, o).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferBuilder.addVertex(matrix4f, -0.5f, 0.5f, -0.5f).setUv(n, o).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            matrices.popPose();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
    }
}

