/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.blocks.deeper_down.flora.SawbladeHollyBushBlock;
import earth.terrarium.pastel.blocks.jade_vines.JadeVinePlantBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShearsDispenseItemBehavior.class})
public class ShearsDispenserBehaviorMixin {
    @Inject(at={@At(value="HEAD")}, method={"tryShearBeehive"}, cancellable=true)
    private static void shearsShearSawbladeHollyBushes(ServerLevel world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        int age;
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is((Block)PastelBlocks.SAWBLADE_HOLLY_BUSH.get()) && SawbladeHollyBushBlock.canBeSheared(age = ((Integer)blockState.getValue((Property)SawbladeHollyBushBlock.AGE)).intValue())) {
            for (ItemStack stack : JadeVinePlantBlock.getHarvestedStacks(blockState, world, pos, world.getBlockEntity(pos), null, Items.SHEARS.getDefaultInstance(), PastelLootTables.SAWBLADE_HOLLY_SHEARING)) {
                SawbladeHollyBushBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
            }
            BlockState newState = (BlockState)blockState.setValue((Property)SawbladeHollyBushBlock.AGE, (Comparable)Integer.valueOf(age - 1));
            world.setBlock(pos, newState, 2);
            world.gameEvent(null, (Holder)GameEvent.SHEAR, pos);
            world.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            cir.setReturnValue((Object)true);
        }
    }
}

