/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import earth.terrarium.pastel.helpers.enchantments.CloversFavorHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LootItemRandomChanceCondition.class})
public abstract class RandomChanceLootConditionMixin {
    @Shadow
    @Final
    private NumberProvider chance;

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"test(Lnet/minecraft/world/level/storage/loot/LootContext;)Z"})
    public boolean applyRareLootEnchantment(boolean original, LootContext context) {
        if (!original) {
            original = context.getRandom().nextFloat() < CloversFavorHelper.rollChance(this.chance.getFloat(context), (Entity)context.getParamOrNull(LootContextParams.ATTACKING_ENTITY));
        }
        return original;
    }
}

