/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import earth.terrarium.pastel.api.entity.PlayerEntityAccessor;
import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.entity.entity.PastelFishingBobberEntity;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.LightGreatswordItem;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityAccessor {
    @Shadow
    private int sleepCounter;
    @Unique
    public PastelFishingBobberEntity fishingBobber;

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract Iterable<ItemStack> getHandSlots();

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    @Shadow
    protected abstract boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose var1);

    @Inject(method={"updateSwimming()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateSwimming(CallbackInfo ci) {
        if (PastelTrinketItem.hasEquipped(this, (Item)PastelItems.RING_OF_DENSER_STEPS.get())) {
            this.setSwimming(false);
            ci.cancel();
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private void stopSleep(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (amount > 0.0f) {
            Player entity = (Player)this;
            MiscPlayerData.get(entity).notifyHit();
        }
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="net/minecraft/world/level/Level.playSound (Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=2)})
    protected void switchCritSound(Level instance, Player except, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, Operation<Void> original) {
        Player player = (Player)this;
        ItemStack stack = this.getItemInHand(InteractionHand.MAIN_HAND);
        MiscPlayerData component = MiscPlayerData.get(player);
        if (stack.getItem() instanceof LightGreatswordItem && component.isLunging()) {
            original.call(new Object[]{instance, except, x, y, z, PastelSounds.LUNGE_CRIT, category, Float.valueOf(1.0f), Float.valueOf(1.0f + this.random.nextFloat() * 0.2f)});
            return;
        }
        original.call(new Object[]{instance, except, x, y, z, sound, category, Float.valueOf(volume), Float.valueOf(pitch)});
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="net/minecraft/world/level/Level.playSound (Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=1)})
    protected void switchSweepSound(Level instance, Player except, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, Operation<Void> original) {
        ItemStack stack = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() == PastelItems.DRACONIC_TWINSWORD.get() && this.getChanneling(stack) > 0) {
            this.level().playSound(except, x, y, z, PastelSounds.ELECTRIC_DISCHARGE, category, 0.75f, 0.9f + this.random.nextFloat() * 0.2f);
            return;
        }
        original.call(new Object[]{instance, except, x, y, z, sound, category, Float.valueOf(volume), Float.valueOf(pitch)});
    }

    @Unique
    protected int getChanneling(ItemStack stack) {
        return Ench.getLevel((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.CHANNELING, stack);
    }

    @Inject(at={@At(value="TAIL")}, method={"jumpFromGround"})
    protected void jumpAdvancementCriterion(CallbackInfo ci) {
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntityMixin;
            PastelCriteria.TAKE_OFF_BELT_JUMP.trigger(serverPlayerEntity);
        }
    }

    @Override
    public void setSpectrumBobber(PastelFishingBobberEntity bobber) {
        this.fishingBobber = bobber;
    }

    @Override
    public void setSleepTimer(int ticks) {
        this.sleepCounter = ticks;
    }

    @Override
    public PastelFishingBobberEntity getSpectrumBobber() {
        return this.fishingBobber;
    }

    @Inject(at={@At(value="HEAD")}, method={"isHurt"}, cancellable=true)
    public void canFoodHeal(CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        if (player.hasEffect(PastelMobEffects.SCARRED)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="HEAD")})
    public void applyWakeUpEffects(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        Player player = (Player)this;
        if (!player.level().isClientSide()) {
            MiscPlayerData.get(player).resetSleepingState(true);
        }
    }

    @WrapOperation(method={"updatePlayerPose"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;setPose(Lnet/minecraft/world/entity/Pose;)V")})
    public void forceSwimmingState(Player instance, Pose entityPose, Operation<Void> original) {
        MiscPlayerData component = MiscPlayerData.get(instance);
        if ((component.shouldLieDown() || instance.hasEffect(PastelMobEffects.FATAL_SLUMBER)) && this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
            instance.setPose(Pose.SWIMMING);
            return;
        }
        original.call(new Object[]{instance, entityPose});
    }
}

