/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin {
    @Shadow
    @Nullable
    private LivingEntity target;

    @Inject(method={"serverAiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;level()Lnet/minecraft/world/level/Level;", ordinal=0)}, cancellable=true)
    public void slowDownAIticks(CallbackInfo ci) {
        Mob entity = (Mob)this;
        if ((entity.hasEffect(PastelMobEffects.ETERNAL_SLUMBER) || entity.hasEffect(PastelMobEffects.FATAL_SLUMBER)) && !SleepStatusEffect.isResistedBy((LivingEntity)entity)) {
            this.target = null;
            ci.cancel();
            return;
        }
        float potency = SleepStatusEffect.getSleepScaling((LivingEntity)entity);
        if (potency <= 0.0f || (double)entity.getRandom().nextFloat() > (double)potency * 0.15) {
            return;
        }
        if ((double)entity.getRandom().nextFloat() < (double)potency * 0.75) {
            this.target = null;
        }
        ci.cancel();
    }
}

