/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.GeodeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GeodeFeature.class})
public abstract class GeodesGenerateWithGemstoneOresMixin {
    @Inject(at={@At(value="TAIL")}, method={"place"})
    public void generate(FeaturePlaceContext<GeodeConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        this.generateGemstoneOres(context);
    }

    @Unique
    private void generateGemstoneOres(FeaturePlaceContext<GeodeConfiguration> context) {
        BlockState oreBlockState;
        BlockState gemBlock = ((GeodeConfiguration)context.config()).geodeBlockSettings.innerLayerProvider.getState(context.random(), context.origin());
        if (gemBlock != null && (oreBlockState = this.getGemstoneOreForGeodeBlock(gemBlock)) != null) {
            BlockState blackslagOreBlockState = this.getGemstoneBlackslagOreForGeodeBlock(gemBlock);
            BlockState deepslateOreBlockState = this.getGemstoneDeepslateOreForGeodeBlock(gemBlock);
            WorldGenLevel world = context.level();
            RandomSource random = context.random();
            for (int distance = 5; distance < 14; ++distance) {
                for (int i = 0; i < 24; ++i) {
                    int xOffset = random.nextInt(distance + 1) * 2 - distance;
                    int yOffset = random.nextInt(distance + 1) * 2 - distance;
                    int zOffset = random.nextInt(distance + 1) * 2 - distance;
                    BlockPos pos = context.origin().offset(xOffset, yOffset, zOffset);
                    BlockState state = world.getBlockState(pos);
                    if (state.is(PastelBlockTags.BLACKSLAG_ORE_REPLACEABLES)) {
                        world.setBlock(pos, blackslagOreBlockState, 3);
                        continue;
                    }
                    if (state.is(BlockTags.DEEPSLATE_ORE_REPLACEABLES)) {
                        world.setBlock(pos, deepslateOreBlockState, 3);
                        continue;
                    }
                    if (!world.getBlockState(pos).is(BlockTags.STONE_ORE_REPLACEABLES)) continue;
                    world.setBlock(pos, oreBlockState, 3);
                }
            }
        }
    }

    @Unique
    private BlockState getGemstoneOreForGeodeBlock(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block.equals(Blocks.AMETHYST_BLOCK)) {
            return ((Block)PastelBlocks.AMETHYST_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.CITRINE_BLOCK.get())) {
            return ((Block)PastelBlocks.CITRINE_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.TOPAZ_BLOCK.get())) {
            return ((Block)PastelBlocks.TOPAZ_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.ONYX_BLOCK.get())) {
            return ((Block)PastelBlocks.ONYX_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.MOONSTONE_BLOCK.get())) {
            return ((Block)PastelBlocks.MOONSTONE_ORE.get()).defaultBlockState();
        }
        return null;
    }

    @Unique
    private BlockState getGemstoneDeepslateOreForGeodeBlock(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block.equals(Blocks.AMETHYST_BLOCK)) {
            return ((Block)PastelBlocks.DEEPSLATE_AMETHYST_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.CITRINE_BLOCK.get())) {
            return ((Block)PastelBlocks.DEEPSLATE_CITRINE_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.TOPAZ_BLOCK.get())) {
            return ((Block)PastelBlocks.DEEPSLATE_TOPAZ_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.ONYX_BLOCK.get())) {
            return ((Block)PastelBlocks.DEEPSLATE_ONYX_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.MOONSTONE_BLOCK.get())) {
            return ((Block)PastelBlocks.DEEPSLATE_MOONSTONE_ORE.get()).defaultBlockState();
        }
        return null;
    }

    @Unique
    private BlockState getGemstoneBlackslagOreForGeodeBlock(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block.equals(Blocks.AMETHYST_BLOCK)) {
            return ((Block)PastelBlocks.BLACKSLAG_AMETHYST_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.CITRINE_BLOCK.get())) {
            return ((Block)PastelBlocks.BLACKSLAG_CITRINE_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.TOPAZ_BLOCK.get())) {
            return ((Block)PastelBlocks.BLACKSLAG_TOPAZ_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.ONYX_BLOCK.get())) {
            return ((Block)PastelBlocks.BLACKSLAG_ONYX_ORE.get()).defaultBlockState();
        }
        if (block.equals(PastelBlocks.MOONSTONE_BLOCK.get())) {
            return ((Block)PastelBlocks.BLACKSLAG_MOONSTONE_ORE.get()).defaultBlockState();
        }
        return null;
    }
}

