/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.api.entity.TouchingWaterAware;
import earth.terrarium.pastel.registries.PastelFluidTags;
import java.util.Set;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityApplyFluidsMixin
implements TouchingWaterAware {
    @Final
    @Shadow
    private Set<TagKey<Fluid>> fluidOnEyes;
    @Unique
    private boolean pastel$isActuallyTouchingWater = false;

    @Override
    public boolean isActuallyTouchingWater() {
        return this.pastel$isActuallyTouchingWater;
    }

    @Override
    public void setActuallyTouchingWater(boolean actuallyTouchingWater) {
        this.pastel$isActuallyTouchingWater = actuallyTouchingWater;
    }

    @Inject(method={"isEyeInFluid"}, at={@At(value="RETURN")}, cancellable=true)
    public void isSubmergedIn(TagKey<Fluid> fluidTag, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && fluidTag == FluidTags.WATER) {
            cir.setReturnValue((Object)this.fluidOnEyes.contains(PastelFluidTags.SWIMMABLE_FLUID));
        }
    }

    @Inject(method={"isUnderWater"}, at={@At(value="RETURN")}, cancellable=true)
    public void isSubmergedInWater(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.fluidOnEyes.contains(PastelFluidTags.SWIMMABLE_FLUID)) {
            cir.setReturnValue((Object)true);
        }
    }
}

