/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.loot.PastelLootFunctionTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetComponentsRandomlyLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetComponentsRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(i -> SetComponentsRandomlyLootFunction.commonFields((RecordCodecBuilder.Instance)i).and((App)DataComponentPatch.CODEC.listOf().fieldOf("options").forGetter(c -> c.options)).apply((Applicative)i, SetComponentsRandomlyLootFunction::new));
    private final List<DataComponentPatch> options;

    SetComponentsRandomlyLootFunction(List<LootItemCondition> conditions, List<DataComponentPatch> options) {
        super(conditions);
        this.options = options;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return PastelLootFunctionTypes.SET_COMPONENTS_RANDOMLY;
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (this.options.isEmpty()) {
            return stack;
        }
        DataComponentPatch changes = this.options.get(context.getRandom().nextInt(this.options.size()));
        stack.applyComponentsAndValidate(changes);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(List<DataComponentPatch> options) {
        return SetComponentsRandomlyLootFunction.simpleBuilder(conditions -> new SetComponentsRandomlyLootFunction((List<LootItemCondition>)conditions, options));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<DataComponentPatch> options = new ArrayList<DataComponentPatch>();

        protected Builder getThis() {
            return this;
        }

        public Builder add(DataComponentPatch changes) {
            this.options.add(changes);
            return this;
        }

        public LootItemFunction build() {
            return new SetComponentsRandomlyLootFunction(this.getConditions(), this.options);
        }
    }
}

