/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class RadiancePinItem
extends PastelTrinketItem {
    public static final int CHECK_EVERY_X_TICKS = 20;
    public static final int MAX_LIGHT_LEVEL = 7;
    public static final BlockState LIGHT_BLOCK_STATE = (BlockState)((Block)PastelBlocks.DECAYING_LIGHT_BLOCK.get()).defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15));
    public static final BlockState LIGHT_BLOCK_STATE_WATER = (BlockState)((BlockState)((Block)PastelBlocks.DECAYING_LIGHT_BLOCK.get()).defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15))).setValue((Property)LightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));

    public RadiancePinItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/radiance_pin"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.radiance_pin.tooltip").withStyle(ChatFormatting.GRAY));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        Level world = entity.level();
        if (!world.isClientSide && world.getGameTime() % 20L == 0L) {
            Player playerEntity;
            if (entity instanceof Player && (playerEntity = (Player)entity).isSpectator()) {
                return;
            }
            BlockPos pos = entity.blockPosition();
            if (!GenericClaimModsCompat.canPlaceBlock(world, pos, (Entity)entity)) {
                return;
            }
            if (!world.isOutsideBuildHeight(pos) && world.getMaxLocalRawBrightness(pos) <= 7) {
                BlockState currentState = world.getBlockState(pos);
                boolean placed = false;
                if (currentState.isAir()) {
                    world.setBlock(pos, LIGHT_BLOCK_STATE, 3);
                    placed = true;
                } else if (currentState.equals(Blocks.WATER.defaultBlockState())) {
                    world.setBlock(pos, LIGHT_BLOCK_STATE_WATER, 3);
                    placed = true;
                } else if (currentState.is((Block)PastelBlocks.DECAYING_LIGHT_BLOCK.get())) {
                    if (((Boolean)currentState.getValue((Property)LightBlock.WATERLOGGED)).booleanValue()) {
                        world.setBlock(pos, LIGHT_BLOCK_STATE_WATER, 3);
                    } else {
                        world.setBlock(pos, LIGHT_BLOCK_STATE, 3);
                    }
                    placed = true;
                }
                if (placed) {
                    RadiancePinItem.sendSmallLightCreatedParticle((ServerLevel)world, pos);
                    world.playSound(null, entity.getX() + 0.5, entity.getY() + 0.5, entity.getZ() + 0.5, PastelSounds.RADIANCE_STAFF_PLACE, SoundSource.PLAYERS, 0.08f, 0.9f + world.random.nextFloat() * 0.2f);
                }
            }
        }
    }

    public static void sendSmallLightCreatedParticle(ServerLevel world, BlockPos blockPos) {
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, Vec3.atCenterOf((Vec3i)blockPos), (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, 4, Vec3.ZERO, new Vec3(0.1, 0.1, 0.1));
    }
}

