/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class PotionPendantItem
extends PastelTrinketItem
implements InkPoweredPotionFillable {
    private static final int TRIGGER_EVERY_X_TICKS = 300;
    private static final int EFFECT_DURATION = 520;
    private final int maxEffectCount;
    private final int maxAmplifier;

    public PotionPendantItem(Item.Properties settings, int maxEffectCount, int maxAmplifier, ResourceLocation unlockIdentifier) {
        super(settings, unlockIdentifier);
        this.maxEffectCount = maxEffectCount;
        this.maxAmplifier = maxAmplifier;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.appendPotionFillableTooltip(stack, tooltip, Component.translatable((String)"item.pastel.potion_pendant.when_worn"), false, context.tickRate());
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects();
    }

    @Override
    public int maxEffectCount() {
        return this.maxEffectCount;
    }

    @Override
    public int maxEffectAmplifier() {
        return this.maxAmplifier;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity;
        Level world = slotContext.entity().level();
        super.onEquip(slotContext, prevStack, stack);
        if (!world.isClientSide && (livingEntity = slotContext.entity()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.grantEffects(stack, player);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level world = entity.level();
        super.curioTick(slotContext, stack);
        if (!world.isClientSide && entity.level().getGameTime() % 300L == 0L && entity instanceof Player) {
            Player player = (Player)entity;
            this.grantEffects(stack, player);
        }
    }

    private void grantEffects(ItemStack stack, Player player) {
        for (InkPoweredStatusEffectInstance inkPoweredEffect : InkPoweredPotionFillable.getEffects(stack)) {
            if (!InkPowered.tryDrainEnergy(player, inkPoweredEffect.getInkCost())) continue;
            MobEffectInstance effect = inkPoweredEffect.getStatusEffectInstance();
            player.addEffect(new MobEffectInstance(effect.getEffect(), 520, effect.getAmplifier(), effect.isAmbient(), effect.isVisible(), true));
        }
    }
}

