/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.FixedSingleInkStorage;
import earth.terrarium.pastel.items.trinkets.InkDrainTrinketItem;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class LaurelsOfSerenityItem
extends InkDrainTrinketItem {
    public static ResourceLocation DETECTION_RANGE_ATTRIBUTE_ID = PastelCommon.locate("laurels_of_serenity_detection_range");
    public static ResourceLocation MENTAL_PRESENCE_ATTRIBUTE_ID = PastelCommon.locate("laurels_of_serenity_mental_presence");

    public LaurelsOfSerenityItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/laurels_of_serenity"), InkColors.PURPLE);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.laurels_of_serenity.tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, type);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        double sleepResistanceMod;
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        double detectionRangeMod = this.getDetectionRangeMultiplier(storedInk);
        if (detectionRangeMod != 0.0) {
            modifiers.put((Object)AdditionalEntityAttributes.MOB_DETECTION_RANGE, (Object)new AttributeModifier(DETECTION_RANGE_ATTRIBUTE_ID, -detectionRangeMod, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if ((sleepResistanceMod = (double)this.getInducedSleepResistanceMod(storedInk)) != 0.0) {
            modifiers.put(PastelEntityAttributes.MENTAL_PRESENCE, (Object)new AttributeModifier(MENTAL_PRESENCE_ATTRIBUTE_ID, sleepResistanceMod, AttributeModifier.Operation.ADD_VALUE));
        }
        return modifiers;
    }

    public float getDetectionRangeMultiplier(long storedInk) {
        if (storedInk < 100L) {
            return 0.0f;
        }
        return 0.15f * (float)((int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0)));
    }

    public float getInducedSleepResistanceMod(long storedInk) {
        if (storedInk < 100L) {
            return 0.0f;
        }
        return 0.15f * (float)((int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0)));
    }
}

