/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.storage.FixedSingleInkStorage;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InkDrainTrinketItem
extends PastelTrinketItem
implements InkStorageItem<FixedSingleInkStorage>,
ExtendedItemBar,
SlotBackgroundEffect {
    public static final int MAX_INK = 0x320000;
    public final InkColor inkColor;
    public static final Map<InkColor, Item> BY_COLOR = new HashMap<InkColor, Item>();

    public InkDrainTrinketItem(Item.Properties settings, ResourceLocation unlockIdentifier, InkColor inkColor) {
        super(settings, unlockIdentifier);
        this.inkColor = inkColor;
        if (BY_COLOR.containsKey(inkColor)) {
            throw new IllegalStateException("Attempted to register multiple ink upgrade-ables to the same color");
        }
        BY_COLOR.put(inkColor, this);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        if (storedInk >= 0x320000L) {
            tooltip.add((Component)Component.translatable((String)"pastel.tooltip.ink_drain.tooltip.maxed_out").withStyle(ChatFormatting.GRAY));
        } else {
            long nextStepInk;
            int pow = 0;
            do {
                nextStepInk = (long)(100.0 * Math.pow(8.0, pow));
                ++pow;
            } while (storedInk >= nextStepInk);
            tooltip.add((Component)Component.translatable((String)"pastel.tooltip.ink_drain.tooltip.ink_for_next_step", (Object[])new Object[]{storedInk, inkStorage.getStoredColor().getColoredInkName(), Support.getShortenedNumberString(nextStepInk - storedInk)}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return this.isMaxedOut(stack);
    }

    private boolean isMaxedOut(ItemStack stack) {
        return this.getEnergyStorage(stack).isFull();
    }

    @Override
    public ItemStack getDefaultInstance() {
        return super.getDefaultInstance();
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.NEVER;
    }

    @Override
    public FixedSingleInkStorage getEnergyStorage(ItemStack itemStack) {
        Iterator<Map.Entry<InkColor, Long>> iterator;
        InkStorageComponent storage = (InkStorageComponent)itemStack.get(PastelDataComponentTypes.INK_STORAGE);
        if (storage != null && (iterator = storage.storedEnergy().entrySet().iterator()).hasNext()) {
            Map.Entry<InkColor, Long> entry = iterator.next();
            return new FixedSingleInkStorage(storage.maxEnergyTotal(), entry.getKey(), entry.getValue());
        }
        return new FixedSingleInkStorage(0x320000L, this.inkColor);
    }

    @Override
    public void setEnergyStorage(ItemStack itemStack, InkStorage storage) {
        itemStack.set(PastelDataComponentTypes.INK_STORAGE, (Object)new InkStorageComponent(storage));
        itemStack.set(DataComponents.RARITY, (Object)(storage.isFull() ? Rarity.EPIC : (Rarity)super.getDefaultInstance().get(DataComponents.RARITY)));
    }

    @Override
    public ItemStack getFullStack() {
        return InkStorageItem.super.getFullStack();
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable Player player, ItemStack stack) {
        return false;
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        FixedSingleInkStorage inkTank = this.getEnergyStorage(stack);
        int progress = (int)Math.round(Mth.clampedLerp((double)0.0, (double)14.0, (double)(Math.log((float)inkTank.getEnergy(this.inkColor) / 100.0f) / Math.log(8.0) / 5.0)));
        if (progress == 0 || progress == 14) {
            return PASS;
        }
        return new ExtendedItemBar.BarSignature(1, 13, 14, progress, 1, this.inkColor.getTextColorInt(), 2, -16777216);
    }

    @Override
    public float getEffectOpacity(@Nullable Player player, ItemStack stack, float tickDelta) {
        FixedSingleInkStorage inkTank = this.getEnergyStorage(stack);
        return (float)(Math.log((float)inkTank.getEnergy(this.inkColor) / 100.0f) / Math.log(8.0) / 5.0);
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        FixedSingleInkStorage inkTank = this.getEnergyStorage(stack);
        return inkTank.isFull() ? SlotBackgroundEffect.SlotEffect.PULSE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return this.inkColor.getColorInt();
    }
}

