/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GleamingPinItem
extends PastelTrinketItem {
    public static final int BASE_RANGE = 12;
    public static final int RANGE_BONUS_PER_LEVEL_OF_SNIPING = 4;
    public static final int EFFECT_DURATION = 240;
    public static final long COOLDOWN_TICKS = 160L;

    public GleamingPinItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/gleaming_pin"));
    }

    public static void doGleamingPinEffect(@NotNull Player player, @NotNull ServerLevel world, ItemStack gleamingPinStack) {
        world.playSound(null, player.getX(), player.getY(), player.getZ(), PastelSounds.RADIANCE_PIN_TRIGGER, SoundSource.PLAYERS, 0.4f, 0.9f + world.getRandom().nextFloat() * 0.2f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, player.position().add(0.0, 0.75, 0.0), (ParticleOptions)PastelParticleTypes.LIQUID_CRYSTAL_SPARKLE, 100, new Vec3(0.0, 0.5, 0.0), new Vec3(2.5, 0.1, 2.5));
        world.getEntities((Entity)player, player.getBoundingBox().inflate((double)GleamingPinItem.getEffectRange(world, gleamingPinStack)), EntitySelector.LIVING_ENTITY_STILL_ALIVE).forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 240, 0, true, true));
            }
        });
    }

    public static int getEffectRange(ServerLevel world, ItemStack stack) {
        return 12 + 4 * Ench.getLevel((HolderLookup.Provider)world.registryAccess(), PastelEnchantments.SNIPING, stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.gleaming_pin.tooltip"));
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(PastelEnchantments.SNIPING);
    }
}

