/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.FixedSingleInkStorage;
import earth.terrarium.pastel.items.trinkets.InkDrainTrinketItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class ExtraMiningSpeedRingItem
extends InkDrainTrinketItem {
    public static ResourceLocation MINING_SPEED_ATTRIBUTE_ID = PastelCommon.locate("ring_of_pursuit_mining_speed");

    public ExtraMiningSpeedRingItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/ring_of_pursuit"), InkColors.MAGENTA);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.ring_of_pursuit.tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, type);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        double miningSpeedMod = this.getExtraMiningSpeed(storedInk);
        if (miningSpeedMod != 0.0) {
            modifiers.put((Object)Attributes.MINING_EFFICIENCY, (Object)new AttributeModifier(MINING_SPEED_ATTRIBUTE_ID, miningSpeedMod, AttributeModifier.Operation.ADD_VALUE));
        }
        return modifiers;
    }

    public double getExtraMiningSpeed(long storedInk) {
        if (storedInk < 100L) {
            return 0.0;
        }
        return 1 + (int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0));
    }
}

