/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.FixedSingleInkStorage;
import earth.terrarium.pastel.api.item.AzureDikeItem;
import earth.terrarium.pastel.items.trinkets.InkDrainTrinketItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;

public class AzureDikeAmuletItem
extends InkDrainTrinketItem
implements AzureDikeItem {
    public AzureDikeAmuletItem(Item.Properties settings, ResourceLocation unlockIdentifier) {
        super(settings, unlockIdentifier, InkColors.BLUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.azure_dike_provider.tooltip", (Object[])new Object[]{this.maxAzureDike(stack)}));
        super.appendHoverText(stack, context, tooltip, type);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        this.recalculate(slotContext.entity());
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        this.recalculate(slotContext.entity());
    }

    @Override
    public int maxAzureDike(ItemStack stack) {
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        if (storedInk < 100L) {
            return 0;
        }
        return this.getDike(storedInk);
    }

    public int getDike(long storedInk) {
        if (storedInk < 100L) {
            return 0;
        }
        return 2 + 2 * (int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0));
    }
}

