/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class AshenCircletItem
extends PastelTrinketItem {
    public static final int FIRE_RESISTANCE_EFFECT_DURATION = 600;
    public static final long COOLDOWN_TICKS = 3000L;
    public static final double LAVA_MOVEMENT_SPEED_MOD = 0.4;
    public static final double LAVA_VIEW_DISTANCE_MOD = 24.0;
    public static ResourceLocation LAVA_SPEED_ATTRIBUTE_ID = PastelCommon.locate("ashen_circlet_lava_speed");
    public static ResourceLocation LAVA_VISIBILITY_ATTRIBUTE_ID = PastelCommon.locate("ashen_circlet_lava_visibility");

    public AshenCircletItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/ashen_circlet"));
    }

    public static long getCooldownTicks(@NotNull ItemStack ashenCircletStack, @NotNull Level world) {
        Long last = (Long)ashenCircletStack.getOrDefault(PastelDataComponentTypes.LAST_COOLDOWN_START, (Object)0L);
        return Math.max(0L, last + 3000L - world.getGameTime());
    }

    private static void setCooldown(@NotNull ItemStack ashenCircletStack, @NotNull Level world) {
        ashenCircletStack.set(PastelDataComponentTypes.LAST_COOLDOWN_START, (Object)world.getGameTime());
    }

    public static void grantFireResistance(@NotNull ItemStack ashenCircletStack, @NotNull LivingEntity livingEntity) {
        if (!livingEntity.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 600, 0, true, true));
            livingEntity.level().playSound(null, livingEntity.blockPosition(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            AshenCircletItem.setCooldown(ashenCircletStack, livingEntity.level());
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        if (entity.isOnFire()) {
            entity.setRemainingFireTicks(0);
        }
        if (AshenCircletItem.getCooldownTicks(stack, entity.level()) == 0L && PrimordialFireData.putOut(entity)) {
            entity.level().playSound(null, entity.blockPosition(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            AshenCircletItem.setCooldown(stack, entity.level());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.ashen_circlet.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.ashen_circlet.tooltip2").withStyle(ChatFormatting.GRAY));
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            long cooldownTicks = AshenCircletItem.getCooldownTicks(stack, (Level)world);
            if (cooldownTicks == 0L) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.ashen_circlet.tooltip.cooldown_full"));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.ashen_circlet.tooltip.cooldown_seconds", (Object[])new Object[]{cooldownTicks / 20L}));
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        modifiers.put((Object)AdditionalEntityAttributes.LAVA_SPEED, (Object)new AttributeModifier(LAVA_SPEED_ATTRIBUTE_ID, 0.4, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put((Object)AdditionalEntityAttributes.LAVA_VISIBILITY, (Object)new AttributeModifier(LAVA_VISIBILITY_ATTRIBUTE_ID, 24.0, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }
}

