/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.item.SleepAlteringItem;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SoothingBouquetItem
extends Item
implements SleepAlteringItem,
SlotBackgroundEffect {
    private static final MutableComponent TOOLTIP = Component.translatable((String)"item.pastel.soothing_bouquet.tooltip");

    public SoothingBouquetItem(Item.Properties settings) {
        super(settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)TOOLTIP.withStyle(ChatFormatting.GRAY));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            MiscPlayerData component = MiscPlayerData.get(player);
            component.setSleepTimers(50, 120, 0);
            component.setLastSleepItem(this);
            player.addEffect(new MobEffectInstance(PastelMobEffects.CALMING, 200, 4));
            player.addEffect(new MobEffectInstance(PastelMobEffects.SOMNOLENCE, 200, 4));
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 50, 3));
        } else {
            user.addEffect(new MobEffectInstance(PastelMobEffects.SOMNOLENCE, 300, 2));
            user.startSleeping(user.blockPosition());
        }
        world.playSound(null, (Entity)user, PastelSounds.LIGHT_CRYSTAL_RING, SoundSource.PLAYERS, 1.0f, 1.2f);
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 40;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.SNIFFER_SCENTING;
    }

    @Override
    public void applyPenalties(Player player) {
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300));
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        return SlotBackgroundEffect.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return 12804078;
    }
}

