/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.item.CreativeOnlyItem;
import earth.terrarium.pastel.blocks.PrimordialFireBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class PrimordialLighterItem
extends FlintAndSteelItem
implements CreativeOnlyItem {
    public static final DispenseItemBehavior DISPENSER_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack execute(BlockSource pointer, ItemStack stack) {
            ServerLevel world = pointer.level();
            this.setSuccess(true);
            Direction direction = (Direction)pointer.state().getValue((Property)DispenserBlock.FACING);
            BlockPos blockPos = pointer.pos().relative(direction);
            if (PrimordialFireBlock.tryPlacePrimordialFire((Level)world, blockPos, direction)) {
                stack.hurtAndBreak(1, world, null, item -> {});
                this.setSuccess(true);
            } else {
                this.setSuccess(false);
            }
            return stack;
        }
    };

    public PrimordialLighterItem(Item.Properties settings) {
        super(settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.primordial_lighter.tooltip").withStyle(ChatFormatting.GRAY));
        CreativeOnlyItem.appendTooltip(tooltip);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        BlockPos blockOnSide;
        Player player = context.getPlayer();
        Level world = context.getLevel();
        if (PrimordialFireBlock.canBePlacedAt((Level)world, (BlockPos)(blockOnSide = (pos = context.getClickedPos()).relative(context.getClickedFace())), (Direction)context.getHorizontalDirection())) {
            world.playSound(player, blockOnSide, PastelSounds.ITEM_PRIMORDIAL_LIGHTER_USE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
            BlockState primordialFireState = ((PrimordialFireBlock)((Object)PastelBlocks.PRIMORDIAL_FIRE.get())).getStateForPosition((BlockGetter)world, blockOnSide);
            world.setBlock(blockOnSide, primordialFireState, 11);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
            ItemStack stack = context.getItemInHand();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayerEntity, blockOnSide, stack);
                stack.hurtAndBreak(1, (LivingEntity)serverPlayerEntity, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.FAIL;
    }
}

