/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.entity.PlayerEntityAccessor;
import earth.terrarium.pastel.compat.gofish.GoFishCompat;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import earth.terrarium.pastel.registries.PastelEnchantments;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;

public abstract class PastelFishingRodItem
extends FishingRodItem {
    public PastelFishingRodItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        PlayerEntityAccessor playerEntityAccessor = (PlayerEntityAccessor)user;
        if (playerEntityAccessor.getSpectrumBobber() != null) {
            if (!world.isClientSide) {
                int damage = playerEntityAccessor.getSpectrumBobber().use(itemStack);
                itemStack.hurtAndBreak(damage, (LivingEntity)user, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            user.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                RegistryAccess drm = world.registryAccess();
                int luckBonus = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverWorld, (ItemStack)itemStack, (Entity)user);
                int waitTimeReductionTicks = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverWorld, (ItemStack)itemStack, (Entity)user) * 20.0f);
                int exuberanceLevel = Ench.getLevel((HolderLookup.Provider)drm, PastelEnchantments.EXUBERANCE, itemStack);
                int bigCatchLevel = Ench.getLevel((HolderLookup.Provider)drm, PastelEnchantments.BIG_CATCH, itemStack);
                int serendipityReelLevel = Ench.getLevel((HolderLookup.Provider)drm, PastelEnchantments.SERENDIPITY_REEL, itemStack);
                boolean inventoryInsertion = Ench.hasEnchantment((HolderLookup.Provider)drm, PastelEnchantments.INVENTORY_INSERTION, itemStack);
                boolean shouldSmeltDrops = this.shouldSmeltDrops(itemStack);
                this.spawnBobber(user, world, luckBonus, waitTimeReductionTicks, exuberanceLevel, bigCatchLevel, serendipityReelLevel, inventoryInsertion, shouldSmeltDrops);
            }
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            user.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    public abstract void spawnBobber(Player var1, Level var2, int var3, int var4, int var5, int var6, int var7, boolean var8, boolean var9);

    public boolean canFishIn(FluidState fluidState) {
        return fluidState.is(FluidTags.WATER);
    }

    public boolean shouldSmeltDrops(ItemStack itemStack) {
        return EnchantmentHelper.hasTag((ItemStack)itemStack, PastelEnchantmentTags.SMELTS_MORE_LOOT) || GoFishCompat.hasDeepfry(itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.pastel_fishing_rods.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

