/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParryingSwordItem
extends SwordItem
implements ExtendedItemBar {
    public static final int DEFAULT_MAX_BLOCK_TIME = 40;
    public static final int DEFAULT_PERFECT_PARRY_WINDOW = 5;

    public ParryingSwordItem(Tier material, int attackDamage, float attackSpeed, float crit, float reach, Item.Properties settings) {
        super(material, settings.attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(material.getAttackDamageBonus() + (float)attackDamage), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(AdditionalEntityAttributes.CRITICAL_BONUS_DAMAGE, new AttributeModifier(PastelEntityAttributes.CRIT_MODIFIER_ID, (double)crit, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(PastelEntityAttributes.REACH_MODIFIER_ID, (double)reach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        super.releaseUsing(stack, world, user, remainingUseTicks);
        int usedTime = this.getMaxShieldingTime(user, stack) - remainingUseTicks;
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        this.cooldownAndDamage(stack, player, usedTime);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        this.releaseUsing(stack, world, user, 0);
        return stack;
    }

    private void cooldownAndDamage(ItemStack stack, Player player, int usedTime) {
        if (usedTime > 1) {
            player.getCooldowns().addCooldown((Item)this, Math.max(usedTime, 10));
        }
        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
    }

    public abstract float getBlockingMultiplier(DamageSource var1, ItemStack var2, LivingEntity var3, int var4);

    public boolean canPerfectParry(ItemStack stack, LivingEntity entity, int usedTime) {
        return usedTime <= this.getPerfectParryWindow(entity, stack);
    }

    public boolean canBluffParry(ItemStack stack, LivingEntity entity, int usedTime) {
        return usedTime <= this.getPerfectParryWindow(entity, stack) * 2;
    }

    public boolean canDeflect(DamageSource source, boolean perfect) {
        if (source.is(DamageTypeTags.NO_IMPACT) || source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            return false;
        }
        if (source.is(DamageTypeTags.BYPASSES_SHIELD)) {
            return perfect;
        }
        return true;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 40;
    }

    public int getMaxShieldingTime(LivingEntity user, ItemStack stack) {
        return this.getUseDuration(stack, user);
    }

    public int getPerfectParryWindow(LivingEntity user, ItemStack stack) {
        return 5;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    protected abstract int getBarColor();

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        if (player == null || !player.isUsingItem()) {
            return ExtendedItemBar.PASS;
        }
        ItemStack activeStack = player.getItemInHand(player.getUsedItemHand());
        if (activeStack != stack) {
            return ExtendedItemBar.PASS;
        }
        int progress = Math.round(Mth.clampedLerp((float)13.0f, (float)0.0f, (float)((float)player.getTicksUsingItem() / (float)this.getMaxShieldingTime((LivingEntity)player, stack))));
        return new ExtendedItemBar.BarSignature(2, 13, 13, progress, 1, this.getBarColor(), 2, -16777216);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return super.canPerformAction(stack, itemAbility) || itemAbility == ItemAbilities.SHIELD_BLOCK;
    }
}

