/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.interaction.OmniAcceleratorProjectile;
import earth.terrarium.pastel.api.render.DynamicItemRenderer;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OmniAcceleratorItem
extends BundleItem
implements InkPowered,
ExtendedItemBar,
SlotBackgroundEffect {
    protected static final InkCost COST = new InkCost(InkColors.YELLOW, 20L);
    protected static final int CHARGE_TIME = 10;

    public OmniAcceleratorItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 10;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (!(user instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)user;
        Optional<ItemStack> shootStackOptional = OmniAcceleratorItem.getFirstStack((HolderLookup.Provider)world.registryAccess(), stack);
        if (shootStackOptional.isEmpty()) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.DISPENSER_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return stack;
        }
        if (!InkPowered.tryDrainEnergy((Player)player, COST)) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), PastelSounds.USE_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return stack;
        }
        ItemStack shootStack = shootStackOptional.get();
        OmniAcceleratorProjectile projectile = OmniAcceleratorProjectile.get(shootStack);
        if (projectile.createProjectile(shootStack, user, world, stack) != null) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), projectile.getSoundEffect(), SoundSource.PLAYERS, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!player.isCreative()) {
                OmniAcceleratorItem.decrementFirstItem(stack);
            }
        }
        return stack;
    }

    public static void decrementFirstItem(ItemStack acceleratorStack) {
        BundleContents comp = (BundleContents)acceleratorStack.get(DataComponents.BUNDLE_CONTENTS);
        if (comp == null) {
            return;
        }
        BundleContents.Mutable builder = new BundleContents.Mutable(BundleContents.EMPTY);
        boolean first = true;
        for (ItemStack stack : comp.itemsCopy()) {
            if (first) {
                stack.shrink(1);
                first = false;
            }
            if (stack.isEmpty()) continue;
            builder.tryInsert(stack);
        }
        acceleratorStack.set(DataComponents.BUNDLE_CONTENTS, (Object)builder.toImmutable());
    }

    public static Optional<ItemStack> getFirstStack(HolderLookup.Provider wrapperLookup, ItemStack stack) {
        BundleContents contents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        return contents.isEmpty() ? Optional.empty() : Optional.of(contents.getItemUnsafe(0).copy());
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(COST.color());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.addInkPoweredTooltip(tooltip);
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        boolean usable = InkPowered.hasAvailableInk(player, COST);
        return usable ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return 0xFFFFFF;
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable Player player, ItemStack stack) {
        if (player == null || player.getItemInHand(player.getUsedItemHand()) != stack) {
            return true;
        }
        return !player.isUsingItem();
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        if (player == null || !player.isUsingItem()) {
            return ExtendedItemBar.PASS;
        }
        ItemStack activeStack = player.getItemInHand(player.getUsedItemHand());
        if (activeStack != stack) {
            return ExtendedItemBar.PASS;
        }
        int progress = Math.round(Mth.clampedLerp((float)0.0f, (float)13.0f, (float)((float)player.getTicksUsingItem() / 10.0f)));
        return new ExtendedItemBar.BarSignature(2, 13, 13, progress, 1, -1, 2, -16777216);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements DynamicItemRenderer {
        @Override
        public void render(ItemRenderer renderer, ItemStack stack, ItemDisplayContext mode, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
            Minecraft client = Minecraft.getInstance();
            if (mode != ItemDisplayContext.GUI || client.level == null) {
                return;
            }
            Optional<ItemStack> optionalStack = OmniAcceleratorItem.getFirstStack((HolderLookup.Provider)client.level.registryAccess(), stack);
            if (optionalStack.isEmpty()) {
                return;
            }
            ItemStack bundledStack = optionalStack.get();
            BakedModel bundledModel = renderer.getModel(bundledStack, (Level)client.level, (LivingEntity)client.player, 0);
            matrices.pushPose();
            matrices.scale(0.5f, 0.5f, 0.5f);
            matrices.translate(0.5f, 0.5f, 0.5f);
            renderer.render(bundledStack, mode, leftHanded, matrices, vertexConsumers, light, overlay, bundledModel);
            matrices.popPose();
        }
    }
}

