/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import com.cmdpro.databank.misc.ColorGradient;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.helpers.level.MobEffectHelper;
import earth.terrarium.pastel.items.tools.LightGreatswordItem;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NectarLanceItem
extends LightGreatswordItem
implements SlotBackgroundEffect {
    public NectarLanceItem(Tier material, int attackDamage, float attackSpeed, float crit, float reach, int barColor, ColorGradient lungeGradient, Item.Properties settings) {
        super(material, attackDamage, attackSpeed, crit, reach, barColor, lungeGradient, settings);
    }

    public NectarLanceItem(Tier material, int attackDamage, float attackSpeed, float crit, float reach, int barColor, Item.Properties settings) {
        super(material, attackDamage, attackSpeed, crit, reach, barColor, settings);
    }

    @Override
    public float getBlockingMultiplier(DamageSource source, ItemStack stack, LivingEntity entity, int usedTime) {
        if (source.is(DamageTypeTags.IS_PROJECTILE)) {
            return 0.0f;
        }
        if (this.canPerfectParry(stack, entity, usedTime)) {
            return 0.0f;
        }
        if (this.canBluffParry(stack, entity, usedTime)) {
            return 0.1f;
        }
        if ((float)usedTime <= (float)this.getMaxShieldingTime(entity, stack) / 2.0f) {
            return 0.25f;
        }
        return 0.6f;
    }

    @Override
    public float getLungeSpeed() {
        return 2.0f;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 30;
    }

    @Override
    protected void applyLungeHitEffects(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        DamageSource magicDamage = attacker.damageSources().magic();
        Level level = attacker.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        float base = EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)stack, (Entity)target, (DamageSource)magicDamage, (float)((float)attacker.getAttributeValue(Attributes.ATTACK_DAMAGE)));
        if (target.hasEffect(MobEffects.POISON)) {
            MobEffectInstance effect = target.getEffect(MobEffects.POISON);
            if (target.removeEffect(MobEffects.POISON)) {
                assert (effect != null);
                NectarLanceItem.applyDoTProc(magicDamage, base + 5.0f, 0.8f, target, effect, false, true);
            }
        } else if (target.hasEffect(PastelMobEffects.DEADLY_POISON)) {
            MobEffectInstance effect = target.getEffect(PastelMobEffects.DEADLY_POISON);
            if (target.removeEffect(PastelMobEffects.DEADLY_POISON)) {
                assert (effect != null);
                NectarLanceItem.applyDoTProc(magicDamage, base + 10.0f, 1.0f, target, effect, true, true);
            }
        } else if (target.hasEffect(MobEffects.WITHER)) {
            MobEffectInstance effect = target.getEffect(MobEffects.WITHER);
            if (target.removeEffect(MobEffects.WITHER)) {
                assert (effect != null);
                NectarLanceItem.applyDoTProc(magicDamage, base + 5.0f, 0.1f, target, effect, true, false);
            }
        } else if (PastelMobEffectTags.hasEffectWithTag(target, PastelMobEffectTags.SOPORIFIC)) {
            float scaling = SleepStatusEffect.getSleepScaling(target);
            if (scaling > 0.0f) {
                target.hurt(PastelDamageTypes.sleep(target.level(), target), scaling);
                target.playSound(PastelSounds.DEEP_CRYSTAL_RING, 0.5f, 0.8f + target.getRandom().nextFloat() * 0.4f);
            }
        } else {
            Optional<MobEffectInstance> stolenEffect = target.getActiveEffects().stream().filter(instance -> ((MobEffect)instance.getEffect().value()).isBeneficial()).filter(instance -> !instance.isInfiniteDuration()).filter(instance -> !MobEffectHelper.resistsRemoval(instance)).findFirst();
            if (stolenEffect.isEmpty() || !target.removeEffect(stolenEffect.get().getEffect())) {
                return;
            }
            MobEffectInstance effect = stolenEffect.get();
            int duration = effect.getDuration();
            int amp = effect.getAmplifier();
            int takenDuration = (int)Math.ceil((double)duration / Math.log10(duration + 1));
            int takenAmp = 0;
            if (attacker.hasEffect(effect.getEffect())) {
                takenAmp += attacker.getEffect(effect.getEffect()).getAmplifier();
            }
            attacker.addEffect(new MobEffectInstance(effect.getEffect(), takenDuration, takenAmp));
            if (amp > 0) {
                target.addEffect(new MobEffectInstance(effect.getEffect(), duration, amp - 1, effect.isAmbient(), effect.isVisible(), effect.showIcon()));
            }
            target.playSound(PastelSounds.SOFT_HUM, 0.275f, 0.8f + target.getRandom().nextFloat() * 0.4f);
        }
    }

    public static boolean sleepCrits(Player player, Entity target) {
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)target;
        if (!player.getMainHandItem().is((Item)PastelItems.NECTAR_LANCE.get())) {
            return false;
        }
        if (livingEntity.isSleeping()) {
            return true;
        }
        float scaling = SleepStatusEffect.getSleepScaling(livingEntity);
        return scaling > 0.0f && livingEntity.getRandom().nextFloat() <= scaling / 3.0f;
    }

    private static void applyDoTProc(DamageSource type, float baseDamage, float damageScaling, LivingEntity target, MobEffectInstance effect, boolean canKill, boolean logScaling) {
        float scaling;
        float duration = (float)effect.getDuration() / 20.0f;
        int level = effect.getAmplifier() + 1;
        float damage = scaling = (float)level * damageScaling;
        if (logScaling) {
            damage = (float)(Math.log(duration) / Math.log(2.0) * (double)scaling);
        }
        damage += baseDamage;
        if (!canKill) {
            damage = Math.min(target.getHealth() - 1.0f, damage);
        }
        target.hurt(type, damage);
        target.playSound(PastelSounds.DEEP_CRYSTAL_RING, 1.25f, 0.9f + target.getRandom().nextFloat() * 0.2f);
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        return SlotBackgroundEffect.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return -8377404;
    }
}

