/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.registries.PastelBlockTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class MultiToolItem
extends DiggerItem {
    public MultiToolItem(Tier material, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(material, PastelBlockTags.MULTITOOL_MINEABLE, settings.attributes(DiggerItem.createAttributes((Tier)material, (float)attackDamage, (float)attackSpeed)));
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult actionResult = InteractionResult.PASS;
        if (this.itemAbilitiesEnabled(context.getItemInHand()) && !(actionResult = Items.IRON_SHOVEL.useOn(context)).consumesAction() && !(actionResult = Items.IRON_AXE.useOn(context)).consumesAction()) {
            actionResult = Items.IRON_HOE.useOn(context);
        }
        if (actionResult.consumesAction()) {
            return actionResult;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (this.itemAbilitiesEnabled(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.workstaff.tooltip.right_click_actions").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.workstaff.tooltip.right_click_actions_disabled").withStyle(ChatFormatting.DARK_RED));
        }
    }

    public boolean itemAbilitiesEnabled(ItemStack stack) {
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(itemAbility) || ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(itemAbility) || ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility);
    }
}

