/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.item.Preenchanted;
import earth.terrarium.pastel.items.ArrowheadCrossbow;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelToolMaterial;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class MalachiteCrossbowItem
extends CrossbowItem
implements Preenchanted,
ArrowheadCrossbow {
    public static final Predicate<ItemStack> PROJECTILES = stack -> stack.is(ItemTags.ARROWS) || stack.is(PastelItemTags.GLASS_ARROWS);

    public MalachiteCrossbowItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public Map<ResourceKey<Enchantment>, Integer> getDefaultEnchantments() {
        return Map.of(Enchantments.PIERCING, 5);
    }

    public static ItemStack getFirstProjectile(ItemStack crossbow) {
        List projectiles = ((ChargedProjectiles)crossbow.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)).getItems();
        return projectiles.isEmpty() ? ItemStack.EMPTY : (ItemStack)projectiles.getFirst();
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return PastelToolMaterial.MALACHITE.getRepairIngredient().test(ingredient) || super.isValidRepairItem(stack, ingredient);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return PROJECTILES;
    }

    @Override
    public float getProjectileVelocityModifier(ItemStack stack) {
        return 1.5f;
    }

    public float getPullTimeModifier(ItemStack stack) {
        return 2.0f;
    }

    @Override
    public float getDivergenceMod(ItemStack stack) {
        return 0.75f;
    }
}

